/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement;

import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.LoggingEvent;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.SimpleConnectionProvider;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.stalactite.sql.statement.SQLOperation;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.StringParamedSQL;
import org.codefilarete.stalactite.sql.statement.WriteOperation;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Maps;
import org.codefilarete.tool.trace.ModifiableInt;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class WriteOperationTest {
    WriteOperationTest() {
    }

    @Test
    void execute_preparedSQL() throws SQLException {
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)connectionMock.prepareStatement(ArgumentMatchers.anyString())).thenReturn((Object)preparedStatementMock);
        HashMap<Integer, ParameterBinder> parameterBinders = new HashMap<Integer, ParameterBinder>();
        parameterBinders.put(1, DefaultParameterBinders.LONG_PRIMITIVE_BINDER);
        parameterBinders.put(2, DefaultParameterBinders.STRING_BINDER);
        WriteOperation testInstance = new WriteOperation((SQLStatement)new PreparedSQL("insert into Toto(id, name) values(?, ?)", parameterBinders), (ConnectionProvider)new SimpleConnectionProvider(connectionMock), writeCount -> {});
        testInstance.setValue((Object)1, (Object)1L);
        testInstance.setValue((Object)2, (Object)"tata");
        testInstance.execute();
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setLong(1, 1L);
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setString(2, "tata");
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).executeLargeUpdate();
    }

    @Test
    void executeBatch_preparedSQL() throws SQLException {
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)connectionMock.prepareStatement(ArgumentMatchers.anyString())).thenReturn((Object)preparedStatementMock);
        ArrayList batchRowCounter = new ArrayList();
        ((PreparedStatement)Mockito.doAnswer(invocation -> {
            batchRowCounter.add(1L);
            return null;
        }).when((Object)preparedStatementMock)).addBatch();
        ((PreparedStatement)Mockito.doAnswer(invocation -> {
            long[] batchCount = Arrays.toPrimitive((Long[])batchRowCounter.toArray(new Long[0]));
            batchRowCounter.clear();
            return batchCount;
        }).when((Object)preparedStatementMock)).executeLargeBatch();
        HashMap<Integer, ParameterBinder> parameterBinders = new HashMap<Integer, ParameterBinder>();
        parameterBinders.put(1, DefaultParameterBinders.LONG_PRIMITIVE_BINDER);
        parameterBinders.put(2, DefaultParameterBinders.STRING_BINDER);
        WriteOperation testInstance = new WriteOperation((SQLStatement)new PreparedSQL("insert into Toto(id, name) values(?, ?)", parameterBinders), (ConnectionProvider)new SimpleConnectionProvider(connectionMock), writeCount -> {});
        testInstance.addBatch((Map)Maps.asMap((Object)1, (Object)1L).add((Object)2, (Object)"Tata"));
        testInstance.executeBatch();
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setLong(1, 1L);
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setString(2, "Tata");
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).executeLargeBatch();
        Mockito.clearInvocations((Object[])new PreparedStatement[]{preparedStatementMock});
        testInstance.addBatch((Map)Maps.asMap((Object)1, (Object)2L).add((Object)2, (Object)"Tata"));
        testInstance.addBatch((Map)Maps.asMap((Object)1, (Object)3L).add((Object)2, (Object)"Toto"));
        testInstance.executeBatch();
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setLong(1, 2L);
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setLong(1, 3L);
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setString(2, "Tata");
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setString(2, "Toto");
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).executeLargeBatch();
    }

    @Test
    void execute_parameterizedSQL() throws SQLException {
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)connectionMock.prepareStatement(ArgumentMatchers.anyString())).thenReturn((Object)preparedStatementMock);
        ArrayList batchRowCounter = new ArrayList();
        ((PreparedStatement)Mockito.doAnswer(invocation -> {
            batchRowCounter.add(1L);
            return null;
        }).when((Object)preparedStatementMock)).addBatch();
        ((PreparedStatement)Mockito.doAnswer(invocation -> {
            long[] batchCount = Arrays.toPrimitive((Long[])batchRowCounter.toArray(new Long[0]));
            batchRowCounter.clear();
            return batchCount;
        }).when((Object)preparedStatementMock)).executeLargeBatch();
        ((PreparedStatement)Mockito.doAnswer(invocation -> 1L).when((Object)preparedStatementMock)).executeLargeUpdate();
        HashMap<String, ParameterBinder> parameterBinders = new HashMap<String, ParameterBinder>();
        parameterBinders.put("id", DefaultParameterBinders.LONG_PRIMITIVE_BINDER);
        parameterBinders.put("name", DefaultParameterBinders.STRING_BINDER);
        WriteOperation testInstance = new WriteOperation((SQLStatement)new StringParamedSQL("insert into Toto(id, name) values(:id, :name)", parameterBinders), (ConnectionProvider)new SimpleConnectionProvider(connectionMock), writeCount -> {});
        testInstance.setValue((Object)"id", (Object)1L);
        testInstance.setValue((Object)"name", (Object)"tata");
        testInstance.execute();
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setLong(1, 1L);
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setString(2, "tata");
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).executeLargeUpdate();
        Mockito.clearInvocations((Object[])new PreparedStatement[]{preparedStatementMock});
        parameterBinders.clear();
        parameterBinders.put("ids", DefaultParameterBinders.LONG_PRIMITIVE_BINDER);
        WriteOperation testInstanceForDelete = new WriteOperation((SQLStatement)new StringParamedSQL("delete from Toto where id in (:ids)", parameterBinders), (ConnectionProvider)new SimpleConnectionProvider(connectionMock), writeCount -> {});
        testInstanceForDelete.addBatch((Map)Maps.asMap((Object)"ids", (Object)Arrays.asList((Object[])new Long[]{1L, 2L, 3L})));
        testInstanceForDelete.executeBatch();
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setLong(1, 1L);
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setLong(2, 2L);
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setLong(3, 3L);
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).executeLargeBatch();
    }

    @Test
    void executeBatch_parameterizedSQL() throws SQLException {
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)connectionMock.prepareStatement(ArgumentMatchers.anyString())).thenReturn((Object)preparedStatementMock);
        ArrayList batchRowCounter = new ArrayList();
        ((PreparedStatement)Mockito.doAnswer(invocation -> {
            batchRowCounter.add(1L);
            return null;
        }).when((Object)preparedStatementMock)).addBatch();
        ((PreparedStatement)Mockito.doAnswer(invocation -> {
            long[] batchCount = Arrays.toPrimitive((Long[])batchRowCounter.toArray(new Long[0]));
            batchRowCounter.clear();
            return batchCount;
        }).when((Object)preparedStatementMock)).executeLargeBatch();
        HashMap<String, ParameterBinder> parameterBinders = new HashMap<String, ParameterBinder>();
        parameterBinders.put("id", DefaultParameterBinders.LONG_PRIMITIVE_BINDER);
        parameterBinders.put("name", DefaultParameterBinders.STRING_BINDER);
        WriteOperation testInstance = new WriteOperation((SQLStatement)new StringParamedSQL("insert into Toto(id, name) values(:id, :name)", parameterBinders), (ConnectionProvider)new SimpleConnectionProvider(connectionMock), writeCount -> {});
        testInstance.addBatch((Map)Maps.asMap((Object)"id", (Object)1L).add((Object)"name", (Object)"Tata"));
        testInstance.executeBatch();
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setLong(1, 1L);
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setString(2, "Tata");
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).executeLargeBatch();
        Mockito.clearInvocations((Object[])new PreparedStatement[]{preparedStatementMock});
        testInstance.addBatch((Map)Maps.asMap((Object)"id", (Object)2L).add((Object)"name", (Object)"Tata"));
        testInstance.addBatch((Map)Maps.asMap((Object)"id", (Object)3L).add((Object)"name", (Object)"Toto"));
        testInstance.executeBatch();
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setLong(1, 2L);
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setLong(1, 3L);
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setString(2, "Tata");
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setString(2, "Toto");
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).executeLargeBatch();
    }

    @Test
    void execute_batchLog_indexedParameters() throws SQLException {
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)connectionMock.prepareStatement(ArgumentMatchers.anyString())).thenReturn((Object)preparedStatementMock);
        ArrayList batchRowCounter = new ArrayList();
        ((PreparedStatement)Mockito.doAnswer(invocation -> {
            batchRowCounter.add(1L);
            return null;
        }).when((Object)preparedStatementMock)).addBatch();
        ((PreparedStatement)Mockito.doAnswer(invocation -> {
            long[] batchCount = Arrays.toPrimitive((Long[])batchRowCounter.toArray(new Long[0]));
            batchRowCounter.clear();
            return batchCount;
        }).when((Object)preparedStatementMock)).executeLargeBatch();
        HashMap<Integer, ParameterBinder> parameterBinders = new HashMap<Integer, ParameterBinder>();
        parameterBinders.put(1, DefaultParameterBinders.LONG_PRIMITIVE_BINDER);
        parameterBinders.put(2, DefaultParameterBinders.STRING_BINDER);
        StringWriter logsRecipient = new StringWriter();
        Logger logger = LogManager.getLogger(SQLOperation.class);
        Level currentLevel = logger.getLevel();
        logger.setLevel(Level.TRACE);
        TestLayout layout = new TestLayout();
        logger.addAppender((Appender)new WriterAppender((Layout)layout, (Writer)logsRecipient));
        WriteOperation testInstance = new WriteOperation((SQLStatement)new PreparedSQL("insert into Toto(id, name) values(?, ?)", parameterBinders), (ConnectionProvider)new SimpleConnectionProvider(connectionMock), writeCount -> {});
        testInstance.addBatch((Map)Maps.asMap((Object)1, (Object)1L).add((Object)2, (Object)"tata"));
        testInstance.addBatch((Map)Maps.asMap((Object)1, (Object)2L).add((Object)2, (Object)"toto"));
        testInstance.executeBatch();
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setLong(1, 1L);
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setLong(1, 2L);
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setString(2, "tata");
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setString(2, "toto");
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).executeLargeBatch();
        String expectedLog = layout.format(new LoggingEvent("toto", (Category)logger, (Priority)Level.TRACE, (Object)"insert into Toto(id, name) values(?, ?) | {1={1=1, 2=tata}, 2={1=2, 2=toto}}", null));
        Assertions.assertThat((String)logsRecipient.toString()).contains(new CharSequence[]{expectedLog});
        logger.setLevel(currentLevel);
    }

    @Test
    void execute_batchLog_namedParameters() throws SQLException {
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)connectionMock.prepareStatement(ArgumentMatchers.anyString())).thenReturn((Object)preparedStatementMock);
        ArrayList batchRowCounter = new ArrayList();
        ((PreparedStatement)Mockito.doAnswer(invocation -> {
            batchRowCounter.add(1L);
            return null;
        }).when((Object)preparedStatementMock)).addBatch();
        ((PreparedStatement)Mockito.doAnswer(invocation -> {
            long[] batchCount = Arrays.toPrimitive((Long[])batchRowCounter.toArray(new Long[0]));
            batchRowCounter.clear();
            return batchCount;
        }).when((Object)preparedStatementMock)).executeLargeBatch();
        HashMap<String, ParameterBinder> parameterBinders = new HashMap<String, ParameterBinder>();
        parameterBinders.put("id", DefaultParameterBinders.LONG_PRIMITIVE_BINDER);
        parameterBinders.put("name", DefaultParameterBinders.STRING_BINDER);
        StringWriter logsRecipient = new StringWriter();
        Logger logger = LogManager.getLogger(SQLOperation.class);
        Level currentLevel = logger.getLevel();
        logger.setLevel(Level.TRACE);
        TestLayout layout = new TestLayout();
        logger.addAppender((Appender)new WriterAppender((Layout)layout, (Writer)logsRecipient));
        WriteOperation testInstance = new WriteOperation((SQLStatement)new StringParamedSQL("insert into Toto(id, name) values(:id, :name)", parameterBinders), (ConnectionProvider)new SimpleConnectionProvider(connectionMock), writeCount -> {});
        testInstance.addBatch((Map)Maps.asMap((Object)"id", (Object)2L).add((Object)"name", (Object)"Tata"));
        testInstance.addBatch((Map)Maps.asMap((Object)"id", (Object)3L).add((Object)"name", (Object)"Toto"));
        testInstance.executeBatch();
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setLong(1, 2L);
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setLong(1, 3L);
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setString(2, "Tata");
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setString(2, "Toto");
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).executeLargeBatch();
        String expectedLog = layout.format(new LoggingEvent("toto", (Category)logger, (Priority)Level.TRACE, (Object)"insert into Toto(id, name) values(:id, :name) | {1={name=Tata, id=2}, 2={name=Toto, id=3}}", null));
        Assertions.assertThat((String)logsRecipient.toString()).contains(new CharSequence[]{expectedLog});
        logger.setLevel(currentLevel);
    }

    @Test
    void execute_sensibleValuesAreNotLogged() throws SQLException {
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)connectionMock.prepareStatement(ArgumentMatchers.anyString())).thenReturn((Object)preparedStatementMock);
        ((PreparedStatement)Mockito.doAnswer(invocation -> 1L).when((Object)preparedStatementMock)).executeLargeUpdate();
        HashMap<Integer, ParameterBinder> parameterBinders = new HashMap<Integer, ParameterBinder>();
        parameterBinders.put(1, DefaultParameterBinders.LONG_PRIMITIVE_BINDER);
        parameterBinders.put(2, DefaultParameterBinders.STRING_BINDER);
        StringWriter logsRecipient = new StringWriter();
        Logger logger = LogManager.getLogger(SQLOperation.class);
        Level currentLevel = logger.getLevel();
        logger.setLevel(Level.TRACE);
        TestLayout layout = new TestLayout();
        logger.addAppender((Appender)new WriterAppender((Layout)layout, (Writer)logsRecipient));
        WriteOperation testInstance = new WriteOperation((SQLStatement)new PreparedSQL("insert into Toto(id, name) values(?, ?)", parameterBinders), (ConnectionProvider)new SimpleConnectionProvider(connectionMock), writeCount -> {});
        testInstance.setNotLoggedParams((Set)Arrays.asSet((Object[])new Integer[]{2}));
        testInstance.setValue((Object)1, (Object)1L);
        testInstance.setValue((Object)2, (Object)"tata");
        testInstance.execute();
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setLong(1, 1L);
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setString(2, "tata");
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).executeLargeUpdate();
        String expectedLog = layout.format(new LoggingEvent("toto", (Category)logger, (Priority)Level.TRACE, (Object)"insert into Toto(id, name) values(?, ?) | {1=1, 2=X-masked value-X}", null));
        Assertions.assertThat((String)logsRecipient.toString()).contains(new CharSequence[]{expectedLog});
        logger.setLevel(currentLevel);
    }

    @Test
    void execute_sensibleValuesAreNotLogged_batchNamedParameters() throws SQLException {
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)connectionMock.prepareStatement(ArgumentMatchers.anyString())).thenReturn((Object)preparedStatementMock);
        ArrayList batchRowCounter = new ArrayList();
        ((PreparedStatement)Mockito.doAnswer(invocation -> {
            batchRowCounter.add(1L);
            return null;
        }).when((Object)preparedStatementMock)).addBatch();
        ((PreparedStatement)Mockito.doAnswer(invocation -> {
            long[] batchCount = Arrays.toPrimitive((Long[])batchRowCounter.toArray(new Long[0]));
            batchRowCounter.clear();
            return batchCount;
        }).when((Object)preparedStatementMock)).executeLargeBatch();
        HashMap<String, ParameterBinder> parameterBinders = new HashMap<String, ParameterBinder>();
        parameterBinders.put("id", DefaultParameterBinders.LONG_PRIMITIVE_BINDER);
        parameterBinders.put("name", DefaultParameterBinders.STRING_BINDER);
        StringWriter logsRecipient = new StringWriter();
        Logger logger = LogManager.getLogger(SQLOperation.class);
        Level currentLevel = logger.getLevel();
        logger.setLevel(Level.TRACE);
        TestLayout layout = new TestLayout();
        logger.addAppender((Appender)new WriterAppender((Layout)layout, (Writer)logsRecipient));
        WriteOperation testInstance = new WriteOperation((SQLStatement)new StringParamedSQL("insert into Toto(id, name) values(:id, :name)", parameterBinders), (ConnectionProvider)new SimpleConnectionProvider(connectionMock), writeCount -> {});
        testInstance.setNotLoggedParams((Set)Arrays.asSet((Object[])new String[]{"name"}));
        testInstance.addBatch((Map)Maps.asMap((Object)"id", (Object)2L).add((Object)"name", (Object)"Tata"));
        testInstance.addBatch((Map)Maps.asMap((Object)"id", (Object)3L).add((Object)"name", (Object)"Toto"));
        testInstance.executeBatch();
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setLong(1, 2L);
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setLong(1, 3L);
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setString(2, "Tata");
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setString(2, "Toto");
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).executeLargeBatch();
        String expectedLog = layout.format(new LoggingEvent("toto", (Category)logger, (Priority)Level.TRACE, (Object)"insert into Toto(id, name) values(:id, :name) | {1={name=X-masked value-X, id=2}, 2={name=X-masked value-X, id=3}}", null));
        Assertions.assertThat((String)logsRecipient.toString()).contains(new CharSequence[]{expectedLog});
        logger.setLevel(currentLevel);
    }

    @Test
    void setValue_listenerIsCalled() throws SQLException {
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connectionMock.prepareStatement(ArgumentMatchers.anyString())).thenReturn(Mockito.mock(PreparedStatement.class));
        HashMap<Integer, ParameterBinder> parameterBinders = new HashMap<Integer, ParameterBinder>();
        parameterBinders.put(1, DefaultParameterBinders.LONG_PRIMITIVE_BINDER);
        parameterBinders.put(2, DefaultParameterBinders.STRING_BINDER);
        final ModifiableInt beforeValuesSetInvokationCount = new ModifiableInt();
        final HashMap capturedValues = new HashMap();
        WriteOperation testInstance = new WriteOperation((SQLStatement)new PreparedSQL("insert into Toto(id, name) values(?, ?)", parameterBinders), (ConnectionProvider)new SimpleConnectionProvider(connectionMock), writeCount -> {});
        testInstance.setListener((SQLOperation.SQLOperationListener)new SQLOperation.SQLOperationListener<Integer>(){

            public void onValuesSet(Map<Integer, ?> values) {
                beforeValuesSetInvokationCount.increment();
            }

            public void onValueSet(Integer param, Object value) {
                capturedValues.put(param, value);
            }
        });
        testInstance.setValue((Object)1, (Object)1L);
        testInstance.setValue((Object)2, (Object)"tata");
        Assertions.assertThat((int)beforeValuesSetInvokationCount.getValue()).isEqualTo(0);
        Assertions.assertThat(capturedValues).isEqualTo((Object)Maps.asHashMap((Object)1, (Object)1L).add((Object)2, (Object)"tata"));
    }

    private static class TestLayout
    extends Layout {
        private final StringAppender appender = new StringAppender();

        private TestLayout() {
        }

        public String format(LoggingEvent event) {
            this.appender.cutTail(this.appender.length());
            this.appender.ccat(new Object[]{event.getLevel(), event.getLoggerName(), event.getRenderedMessage(), LINE_SEP, "\t"});
            return this.appender.toString();
        }

        public boolean ignoresThrowable() {
            return false;
        }

        public void activateOptions() {
        }
    }
}

