/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Queue;
import org.codefilarete.stalactite.engine.EntityMappingConfiguration;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.PersisterRegistry;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderImpl;
import org.codefilarete.tool.collection.KeepOrderSet;

public class PersisterBuilderContext {
    public static final ThreadLocal<PersisterBuilderContext> CURRENT = new ThreadLocal();
    private final KeepOrderSet<PersisterBuilderImpl.BuildLifeCycleListener> buildLifeCycleListeners = new KeepOrderSet();
    private final Queue<Class> treatedConfigurations = Collections.asLifoQueue(new ArrayDeque());
    private final PersisterRegistry persisterRegistry;

    public PersisterBuilderContext(PersisterRegistry persisterRegistry) {
        this.persisterRegistry = persisterRegistry;
    }

    public PersisterRegistry getPersisterRegistry() {
        return this.persisterRegistry;
    }

    public KeepOrderSet<PersisterBuilderImpl.BuildLifeCycleListener> getBuildLifeCycleListeners() {
        return this.buildLifeCycleListeners;
    }

    public void addBuildLifeCycleListener(PersisterBuilderImpl.BuildLifeCycleListener listener) {
        this.buildLifeCycleListeners.add((Object)listener);
    }

    public void runInContext(EntityMappingConfiguration<?, ?> entityMappingConfiguration, Runnable callable) {
        this.runInContext(entityMappingConfiguration.getEntityType(), callable);
    }

    public void runInContext(EntityPersister<?, ?> entityMappingConfiguration, Runnable callable) {
        this.runInContext(entityMappingConfiguration.getClassToPersist(), callable);
    }

    private void runInContext(Class entityClass, Runnable callable) {
        try {
            this.treatedConfigurations.add(entityClass);
            callable.run();
        }
        finally {
            this.treatedConfigurations.remove();
        }
    }

    public boolean isCycling(EntityMappingConfiguration<?, ?> entityMappingConfiguration) {
        return this.treatedConfigurations.contains(entityMappingConfiguration.getEntityType());
    }
}

