/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.builder;

import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.builder.FunctionSQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.SelectSQLBuilderFactory;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.query.model.Select;
import org.codefilarete.stalactite.query.model.SelectChain;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.DefaultTypeMapping;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class SelectSQLBuilderTest {
    public static Object[][] toSQL_data() {
        Table tableToto = new Table(null, "Toto");
        Column colTotoA = tableToto.addColumn("a", Integer.class);
        Column colTotoB = tableToto.addColumn("b", Integer.class);
        Table tableTata = new Table(null, "Tata");
        Column colTataA = tableTata.addColumn("a", String.class);
        Column colTataB = tableTata.addColumn("b", String.class);
        Maps.ChainingMap tableAliases = Maps.asMap((Object)tableToto, (Object)"to").add((Object)tableTata, (Object)"ta");
        Map emptyMap = Collections.emptyMap();
        return new Object[][]{{new Select().add("a", String.class), tableAliases, "a"}, {new Select().add("a", String.class).as("aa"), tableAliases, "a as aa"}, {new Select().distinct().add("a", String.class), tableAliases, "distinct a"}, {new Select().add("a", String.class).distinct(), tableAliases, "distinct a"}, {new Select().add("a", String.class).add("b", String.class), tableAliases, "a, b"}, {new Select().add((Selectable)colTotoA), emptyMap, "Toto.a"}, {new Select().add((Selectable)colTotoA), tableAliases, "to.a"}, {new Select().add((Selectable)colTotoA, new Selectable[]{colTotoB}), emptyMap, "Toto.a, Toto.b"}, {new Select().add((Selectable)colTotoA, new Selectable[]{colTotoB}), tableAliases, "to.a, to.b"}, {new Select().add((Selectable)colTotoA, new Selectable[]{colTataB}), emptyMap, "Toto.a, Tata.b"}, {new Select().add((Selectable)colTotoA, new Selectable[]{colTataB}), tableAliases, "to.a, ta.b"}, {new Select().add((Selectable)colTotoA, new Selectable[]{colTataB}).distinct(), tableAliases, "distinct to.a, ta.b"}, {new Select().add((Selectable)colTotoA, "A"), emptyMap, "Toto.a as A"}, {new Select().add((Selectable)colTotoA, "A"), tableAliases, "to.a as A"}, {new Select().add((Selectable)Operators.min((Selectable)colTotoA), "tutu"), tableAliases, "min(to.a) as tutu"}, {new Select().add((Selectable)Operators.min((Selectable)colTotoA), new Selectable[]{Operators.max((Selectable)colTotoA)}), tableAliases, "min(to.a), max(to.a)"}, {new Select().add((Iterable)Arrays.asList((Object[])new Column[]{colTotoA, colTotoB})).add((Selectable)colTataA), emptyMap, "Toto.a, Toto.b, Tata.a"}};
    }

    @ParameterizedTest
    @MethodSource(value={"toSQL_data"})
    public void toSQL(SelectChain<Select> select, Map<Table, String> tableAliases, String expected) {
        SelectSQLBuilderFactory.SelectSQLBuilder testInstance = new SelectSQLBuilderFactory.SelectSQLBuilder((Select)select.getSelect(), tableAliases, new FunctionSQLBuilderFactory.FunctionSQLBuilder(new DMLNameProvider(tableAliases), (JavaTypeToSqlTypeMapping)new DefaultTypeMapping()));
        Assertions.assertThat((String)testInstance.toSQL()).isEqualTo(expected);
    }
}

