/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.util.function.Consumer;
import java.util.function.Function;
import org.codefilarete.stalactite.engine.MappingConfigurationException;
import org.codefilarete.stalactite.engine.PropertyOptions;
import org.codefilarete.stalactite.engine.SeparateTransactionExecutor;
import org.codefilarete.stalactite.mapping.id.sequence.PooledHiLoSequence;
import org.codefilarete.stalactite.mapping.id.sequence.PooledHiLoSequenceOptions;
import org.codefilarete.stalactite.mapping.id.sequence.SequencePersister;
import org.codefilarete.stalactite.mapping.id.sequence.SequenceStorageOptions;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.function.Converter;
import org.codefilarete.tool.function.Sequence;

public interface ColumnOptions<O>
extends PropertyOptions<O> {
    @Override
    public ColumnOptions<O> mandatory();

    @Override
    public ColumnOptions<O> setByConstructor();

    @Override
    public ColumnOptions<O> readonly();

    @Override
    public ColumnOptions<O> columnName(String var1);

    @Override
    public ColumnOptions<O> column(Column<? extends Table, ? extends O> var1);

    @Override
    public ColumnOptions<O> fieldName(String var1);

    @Override
    public ColumnOptions<O> readConverter(Converter<O, O> var1);

    @Override
    public ColumnOptions<O> writeConverter(Converter<O, O> var1);

    @Override
    public <V> PropertyOptions<O> sqlBinder(ParameterBinder<V> var1);

    public static class AlreadyAssignedIdentifierPolicySupport<C, I>
    implements AlreadyAssignedIdentifierPolicy<C, I> {
        private final Consumer<C> markAsPersistedFunction;
        private final Function<C, Boolean> isPersistedFunction;

        public AlreadyAssignedIdentifierPolicySupport(Consumer<C> markAsPersistedFunction, Function<C, Boolean> isPersistedFunction) {
            this.markAsPersistedFunction = markAsPersistedFunction;
            this.isPersistedFunction = isPersistedFunction;
        }

        @Override
        public Consumer<C> getMarkAsPersistedFunction() {
            return this.markAsPersistedFunction;
        }

        @Override
        public Function<C, Boolean> getIsPersistedFunction() {
            return this.isPersistedFunction;
        }
    }

    public static interface AlreadyAssignedIdentifierPolicy<C, I>
    extends IdentifierPolicy<I> {
        public Consumer<C> getMarkAsPersistedFunction();

        public Function<C, Boolean> getIsPersistedFunction();
    }

    public static class DefaultBeforeInsertIdentifierPolicySupport
    implements BeforeInsertIdentifierPolicy<Long> {
        private final SequenceStorageOptions storageOptions;

        public DefaultBeforeInsertIdentifierPolicySupport() {
            this.storageOptions = SequenceStorageOptions.DEFAULT;
        }

        public DefaultBeforeInsertIdentifierPolicySupport(SequenceStorageOptions sequenceStorageOptions) {
            this.storageOptions = sequenceStorageOptions;
        }

        @Override
        public Sequence<Long> getIdentifierProvider(Class<?> entityType, ConnectionConfiguration connectionConfiguration, Dialect dialect) {
            PooledHiLoSequenceOptions options = new PooledHiLoSequenceOptions(50, entityType.getSimpleName());
            ConnectionProvider connectionProvider = connectionConfiguration.getConnectionProvider();
            if (!(connectionProvider instanceof SeparateTransactionExecutor)) {
                throw new MappingConfigurationException("Before-insert identifier policy configured with connection that doesn't support separate transaction, please provide a " + Reflections.toString(SeparateTransactionExecutor.class) + " as connection provider or change identifier policy");
            }
            return new PooledHiLoSequence(options, new SequencePersister(this.storageOptions, dialect, (SeparateTransactionExecutor)connectionProvider, connectionConfiguration.getBatchSize()));
        }
    }

    public static class BeforeInsertIdentifierPolicySupport<I>
    implements BeforeInsertIdentifierPolicy<I> {
        private final Sequence<I> identifierProvider;

        public BeforeInsertIdentifierPolicySupport(Sequence<I> identifierProvider) {
            this.identifierProvider = identifierProvider;
        }

        @Override
        public Sequence<I> getIdentifierProvider(Class<?> entityType, ConnectionConfiguration connectionConfiguration, Dialect dialect) {
            return this.identifierProvider;
        }
    }

    public static interface BeforeInsertIdentifierPolicy<I>
    extends IdentifierPolicy<I> {
        public Sequence<I> getIdentifierProvider(Class<?> var1, ConnectionConfiguration var2, Dialect var3);
    }

    public static class AfterInsertIdentifierPolicySupport<I>
    implements AfterInsertIdentifierPolicy<I> {
    }

    public static interface AfterInsertIdentifierPolicy<I>
    extends IdentifierPolicy<I> {
    }

    public static interface IdentifierPolicy<ID> {
        public static <I> AfterInsertIdentifierPolicy<I> afterInsert() {
            return new AfterInsertIdentifierPolicySupport();
        }

        public static BeforeInsertIdentifierPolicy<Long> beforeInsert() {
            return new DefaultBeforeInsertIdentifierPolicySupport();
        }

        public static BeforeInsertIdentifierPolicy<Long> beforeInsert(SequenceStorageOptions sequenceStorageOptions) {
            return new DefaultBeforeInsertIdentifierPolicySupport(sequenceStorageOptions);
        }

        public static <I> BeforeInsertIdentifierPolicy<I> beforeInsert(Sequence<I> sequence) {
            return new BeforeInsertIdentifierPolicySupport<I>(sequence);
        }

        public static <C, I> AlreadyAssignedIdentifierPolicy<C, I> alreadyAssigned(Consumer<C> markAsPersistedFunction, Function<C, Boolean> isPersistedFunction) {
            return new AlreadyAssignedIdentifierPolicySupport(markAsPersistedFunction, isPersistedFunction);
        }
    }
}

