/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.statement.SQLExecutionException;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.tool.bean.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SQLOperation<ParamType>
implements AutoCloseable {
    public static final Logger LOGGER = LoggerFactory.getLogger(SQLOperation.class);
    public static final SQLOperationListener NOOP_LISTENER = new SQLOperationListener(){};
    protected final ConnectionProvider connectionProvider;
    protected PreparedStatement preparedStatement;
    protected final SQLStatement<ParamType> sqlStatement;
    private SQLOperationListener<ParamType> listener = NOOP_LISTENER;
    private String sql;
    private Set<ParamType> notLoggedParams = Collections.emptySet();
    private Integer timeout = null;

    public SQLOperation(SQLStatement<ParamType> sqlStatement, ConnectionProvider connectionProvider) {
        this.sqlStatement = sqlStatement;
        this.connectionProvider = connectionProvider;
    }

    public ConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    public SQLStatement<ParamType> getSqlStatement() {
        return this.sqlStatement;
    }

    public SQLOperationListener<ParamType> getListener() {
        return this.listener;
    }

    public void setListener(@Nullable SQLOperationListener<ParamType> listener) {
        this.listener = (SQLOperationListener)Objects.preventNull(listener, (Object)NOOP_LISTENER);
    }

    public void setValues(Map<ParamType, ?> values) {
        this.listener.onValuesSet(values);
        this.sqlStatement.setValues(values);
    }

    public void setValue(ParamType index, Object value) {
        this.listener.onValueSet(index, value);
        this.sqlStatement.setValue(index, value);
    }

    protected void ensureStatement() throws SQLException {
        Connection connection = this.connectionProvider.giveConnection();
        if (this.preparedStatement == null) {
            this.prepareStatement(connection);
        }
    }

    protected void prepareStatement(Connection connection) throws SQLException {
        this.preparedStatement = connection.prepareStatement(this.getSQL());
    }

    protected String getSQL() {
        if (this.sql == null) {
            this.sql = this.sqlStatement.getSQL();
        }
        return this.sql;
    }

    protected void prepareExecute() {
        this.listener.onExecute(this.sqlStatement);
        this.applyValuesToEnsuredStatement();
        this.logExecution();
        try {
            this.applyTimeout();
        }
        catch (SQLException e) {
            throw new SQLExecutionException(this.getSQL(), e);
        }
    }

    protected void applyValuesToEnsuredStatement() {
        try {
            this.ensureStatement();
        }
        catch (RuntimeException | SQLException e) {
            throw new SQLStatement.BindingException("Error while creating statement " + this.getSQL(), e);
        }
        try {
            this.sqlStatement.applyValues(this.preparedStatement);
        }
        catch (RuntimeException e) {
            throw new SQLStatement.BindingException("Error while applying values " + this.sqlStatement.values + " on statement " + this.getSQL(), e);
        }
    }

    public void cancel() throws SQLException {
        if (this.preparedStatement != null) {
            this.preparedStatement.cancel();
        }
    }

    @Nullable
    public PreparedStatement getPreparedStatement() {
        return this.preparedStatement;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public void close() {
        try {
            this.preparedStatement.close();
        }
        catch (SQLException e) {
            LOGGER.warn("Can't close statement properly", (Throwable)e);
        }
    }

    public void setNotLoggedParams(@Nonnull Set<ParamType> notLoggedParams) {
        this.notLoggedParams = notLoggedParams;
    }

    protected Map<ParamType, Object> filterLoggable(Map<ParamType, ?> values) {
        HashMap loggedValues = new HashMap(values);
        loggedValues.entrySet().forEach(e -> {
            if (this.notLoggedParams.contains(e.getKey())) {
                e.setValue("X-masked value-X");
            }
        });
        return loggedValues;
    }

    protected void applyTimeout() throws SQLException {
        if (this.getTimeout() != null) {
            this.preparedStatement.setQueryTimeout(this.getTimeout());
        }
    }

    protected void logExecution() {
        this.logExecution(this.filterLoggable(this.sqlStatement.getValues()).toString());
    }

    protected void logExecution(String printableValues) {
        if (LOGGER.isDebugEnabled() && !LOGGER.isTraceEnabled()) {
            LOGGER.debug(this.sqlStatement.getSQLSource());
        } else if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("{} | {}", (Object)this.sqlStatement.getSQLSource(), (Object)printableValues);
        }
    }

    public static interface SQLOperationListener<ParamType> {
        default public void onValuesSet(Map<ParamType, ?> values) {
        }

        default public void onValueSet(ParamType param, Object value) {
        }

        default public void onExecute(SQLStatement<ParamType> sqlStatement) {
        }
    }
}

