/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.diff;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.codefilarete.stalactite.engine.diff.Diff;
import org.codefilarete.stalactite.engine.diff.IndexedDiff;
import org.codefilarete.stalactite.engine.diff.State;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderMap;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.collection.PairIterator;
import org.codefilarete.tool.function.Predicates;
import org.codefilarete.tool.trace.ModifiableInt;

public class CollectionDiffer<C> {
    private final Function<C, ?> idProvider;

    public CollectionDiffer(Function<C, ?> idProvider) {
        this.idProvider = idProvider;
    }

    public <I> KeepOrderSet<Diff<C>> diff(Collection<C> before, Collection<C> after) {
        Map beforeMappedOnIdentifier = Iterables.map(before, this.idProvider, Function.identity(), KeepOrderMap::new);
        Map afterMappedOnIdentifier = Iterables.map(after, this.idProvider, Function.identity(), KeepOrderMap::new);
        KeepOrderSet result = new KeepOrderSet();
        for (Map.Entry entry : beforeMappedOnIdentifier.entrySet()) {
            Object afterId = afterMappedOnIdentifier.get(entry.getKey());
            if (afterId != null) {
                result.add(new Diff(State.HELD, entry.getValue(), afterId));
                continue;
            }
            result.add(new Diff<Object>(State.REMOVED, entry.getValue(), null));
        }
        afterMappedOnIdentifier.keySet().removeAll(beforeMappedOnIdentifier.keySet());
        for (Map.Entry identifiedEntry : afterMappedOnIdentifier.entrySet()) {
            result.add(new Diff<Object>(State.ADDED, null, identifiedEntry.getValue()));
        }
        return result;
    }

    public KeepOrderSet<IndexedDiff<C>> diffOrdered(Collection<C> before, Collection<C> after) {
        KeepOrderMap beforeIndexes = new KeepOrderMap();
        KeepOrderMap afterIndexes = new KeepOrderMap();
        ModifiableInt beforeIndex = new ModifiableInt(0);
        before.forEach(arg_0 -> CollectionDiffer.lambda$diffOrdered$1((Map)beforeIndexes, beforeIndex, arg_0));
        ModifiableInt afterIndex = new ModifiableInt(0);
        after.forEach(arg_0 -> CollectionDiffer.lambda$diffOrdered$3((Map)afterIndexes, afterIndex, arg_0));
        KeepOrderSet result = new KeepOrderSet();
        Set removeds = Iterables.minus(beforeIndexes.keySet(), afterIndexes.keySet());
        removeds.forEach(arg_0 -> CollectionDiffer.lambda$diffOrdered$4(result, (Map)beforeIndexes, arg_0));
        Set addeds = Iterables.minus(afterIndexes.keySet(), beforeIndexes.keySet(), KeepOrderSet::new);
        addeds.forEach(arg_0 -> CollectionDiffer.lambda$diffOrdered$5(result, (Map)afterIndexes, arg_0));
        Set helds = Iterables.intersect(afterIndexes.keySet(), beforeIndexes.keySet());
        helds.forEach(arg_0 -> this.lambda$diffOrdered$9((Map)beforeIndexes, (Map)afterIndexes, before, after, result, arg_0));
        return result;
    }

    private /* synthetic */ void lambda$diffOrdered$9(Map beforeIndexes, Map afterIndexes, Collection before, Collection after, KeepOrderSet result, Object e) {
        Iterable indexPairs = () -> new PairIterator.UntilBothIterator((Iterable)beforeIndexes.get(e), (Iterable)afterIndexes.get(e));
        IndexedDiff<Object> removed = new IndexedDiff<Object>(State.REMOVED, e, null);
        Object id = this.idProvider.apply(e);
        IndexedDiff<Object> held = new IndexedDiff<Object>(State.HELD, Iterables.find((Iterable)before, c -> Predicates.equalOrNull(this.idProvider.apply(c), (Object)id)), Iterables.find((Iterable)after, c -> Predicates.equalOrNull(this.idProvider.apply(c), (Object)id)));
        IndexedDiff<Object> added = new IndexedDiff<Object>(State.ADDED, null, e);
        for (Duo indexPair : indexPairs) {
            if (indexPair.getLeft() != null && indexPair.getRight() != null) {
                held.addSourceIndex((Integer)indexPair.getLeft());
                held.addReplacerIndex((Integer)indexPair.getRight());
                continue;
            }
            if (indexPair.getRight() == null) {
                removed.addSourceIndex((Integer)indexPair.getLeft());
                continue;
            }
            if (indexPair.getLeft() != null) continue;
            added.addReplacerIndex((Integer)indexPair.getRight());
        }
        if (!removed.getSourceIndexes().isEmpty()) {
            result.add(removed);
        }
        if (!held.getReplacerIndexes().isEmpty()) {
            result.add(held);
        }
        if (!added.getReplacerIndexes().isEmpty()) {
            result.add(added);
        }
    }

    private static /* synthetic */ void lambda$diffOrdered$5(KeepOrderSet result, Map afterIndexes, Object e) {
        result.add(new IndexedDiff<Object>(State.ADDED, null, e, new HashSet<Integer>(), (Set)afterIndexes.get(e)));
    }

    private static /* synthetic */ void lambda$diffOrdered$4(KeepOrderSet result, Map beforeIndexes, Object e) {
        result.add(new IndexedDiff<Object>(State.REMOVED, e, null, (Set)beforeIndexes.get(e), (Set<Integer>)new HashSet<Integer>()));
    }

    private static /* synthetic */ void lambda$diffOrdered$3(Map afterIndexes, ModifiableInt afterIndex, Object o) {
        afterIndexes.computeIfAbsent(o, k -> new HashSet()).add(afterIndex.increment());
    }

    private static /* synthetic */ void lambda$diffOrdered$1(Map beforeIndexes, ModifiableInt beforeIndex, Object o) {
        beforeIndexes.computeIfAbsent(o, k -> new HashSet()).add(beforeIndex.increment());
    }
}

