/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query;

import java.util.List;
import java.util.function.BiFunction;
import org.codefilarete.stalactite.engine.runtime.AdvancedEntityPersister;
import org.codefilarete.stalactite.spring.repository.query.PartTreeStalactiteProjection;
import org.codefilarete.stalactite.spring.repository.query.PartTreeStalactiteQuery;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.data.support.PageableExecutionUtils;

public class PartTreeStalactitePagedQuery<C, R extends Slice<C>>
implements RepositoryQuery {
    private final PartTreeStalactiteQuery<C, List<C>> delegate;
    private final BiFunction<StalactiteParametersParameterAccessor, List<C>, R> queryResultSlicer;

    public PartTreeStalactitePagedQuery(QueryMethod method, AdvancedEntityPersister<C, ?> entityPersister, PartTree tree) {
        this.delegate = new PartTreeStalactiteQuery(method, entityPersister, tree, Accumulators.toList());
        if (method.isSliceQuery()) {
            this.queryResultSlicer = (accessor, result) -> {
                int pageSize = 0;
                Pageable pageable = accessor.getPageable();
                if (pageable.isPaged()) {
                    pageSize = pageable.getPageSize();
                }
                boolean hasNext = pageable.isPaged() && result.size() > pageSize;
                return new SliceImpl(hasNext ? result.subList(0, pageSize) : result, pageable, hasNext);
            };
        } else if (method.isPageQuery()) {
            PartTreeStalactiteProjection countQuery = PartTreeStalactiteProjection.forCount(method, entityPersister, tree);
            this.queryResultSlicer = (accessor, result) -> PageableExecutionUtils.getPage((List)result, (Pageable)accessor.getPageable(), () -> (Long)countQuery.execute(accessor.getValues()));
        } else {
            throw new IllegalArgumentException("Query is not pageable " + method);
        }
    }

    public R execute(Object[] parameters) {
        StalactiteParametersParameterAccessor smartParameters = new StalactiteParametersParameterAccessor(this.getQueryMethod().getParameters(), parameters);
        Pageable pageable = smartParameters.getPageable();
        if (this.delegate.getQueryMethod().isSliceQuery() && pageable.getPageNumber() == 0) {
            this.delegate.query.executableEntityQuery.getQueryPageSupport().limit(pageable.getPageSize() + 1);
        } else {
            this.delegate.query.executableEntityQuery.getQueryPageSupport().limit(pageable.getPageSize(), Integer.valueOf((int)pageable.getOffset()));
        }
        return (R)((Slice)this.queryResultSlicer.apply(smartParameters, this.delegate.execute(parameters)));
    }

    public QueryMethod getQueryMethod() {
        return this.delegate.getQueryMethod();
    }

    public static class StalactiteParametersParameterAccessor
    extends ParametersParameterAccessor {
        public StalactiteParametersParameterAccessor(Parameters<?, ?> parameters, Object[] values) {
            super(parameters, values);
        }

        public Object[] getValues() {
            return super.getValues();
        }
    }
}

