/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.ddl.structure;

import java.util.Collection;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.ForeignKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.junit.jupiter.api.Test;

class TableTest {
    TableTest() {
    }

    @Test
    void addColumn_alreadyExists_returnsExistingOne() {
        Table testInstance = new Table("toto");
        Column xxColumn = testInstance.addColumn("xx", String.class);
        Column newColumn = testInstance.addColumn("xx", String.class);
        Assertions.assertThat((Object)newColumn).isSameAs((Object)xxColumn);
    }

    @Test
    void addColumn_alreadyExistsWithDifferentType_throwsException() {
        Table testInstance = new Table("toto");
        testInstance.addColumn("xx", String.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> testInstance.addColumn("xx", Integer.class)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Trying to add column 'xx' to 'toto' but it already exists with a different type : j.l.String vs j.l.Integer");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> testInstance.addColumn("xx", String.class, Integer.valueOf(12))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Trying to add column 'xx' to 'toto' but it already exists with a different type : j.l.String vs j.l.String(12)");
    }

    @Test
    void addForeignKey_alreadyExists_returnsExistingOne() {
        Table testInstance = new Table("toto");
        Column xColumn = testInstance.addColumn("x", String.class);
        Table referencedInstance = new Table("tata");
        Column yColumn = referencedInstance.addColumn("y", String.class);
        ForeignKey fk = testInstance.addForeignKey("dummy FK name", xColumn, yColumn);
        ForeignKey newFK = testInstance.addForeignKey("dummy FK name", xColumn, yColumn);
        Assertions.assertThat((Object)newFK).isSameAs((Object)fk);
    }

    @Test
    void addForeignKey_alreadyExistsWithDifferentType_throwsException() {
        Table testInstance = new Table("toto");
        Column xColumn = testInstance.addColumn("x", String.class);
        Column xxColumn = testInstance.addColumn("xx", String.class);
        Table referencedInstance = new Table("tata");
        Column yColumn = referencedInstance.addColumn("y", String.class);
        testInstance.addForeignKey("dummy FK name", xColumn, yColumn);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> testInstance.addForeignKey("dummy FK name", xxColumn, yColumn)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Trying to add a foreign key with same name than another with different columns : dummy FK name toto.x -> tata.y vs toto.xx -> tata.y");
    }

    @Test
    void findColumn() {
        Table testInstance = new Table("toto");
        Assertions.assertThat((Object)testInstance.findColumn("xx")).isNull();
        Column nameColumn = testInstance.addColumn("name", String.class);
        Assertions.assertThat((Object)testInstance.findColumn("name")).isSameAs((Object)nameColumn);
        Assertions.assertThat((Object)testInstance.findColumn("xx")).isNull();
    }

    @Test
    void getAbsoluteName() {
        Table testInstance = new Table("toto");
        Column nameColumn = testInstance.addColumn("name", String.class);
        Assertions.assertThat((String)nameColumn.getAbsoluteName()).isEqualTo("toto.name");
    }

    @Test
    void getAlias() {
        Table testInstance = new Table("toto");
        Column nameColumn = testInstance.addColumn("name", String.class);
        Assertions.assertThat((String)nameColumn.getAlias()).isEqualTo("toto_name");
    }

    @Test
    void getPrimaryKey() {
        Table testInstance = new Table("toto");
        Assertions.assertThat((Object)testInstance.getPrimaryKey()).isNull();
        testInstance.addColumn("dummyColumn", String.class);
        Assertions.assertThat((Object)testInstance.getPrimaryKey()).isNull();
        Column id = testInstance.addColumn("id", Long.TYPE);
        id.primaryKey();
        Column subId = testInstance.addColumn("subId", Long.TYPE);
        subId.primaryKey();
        Assertions.assertThat((Object)testInstance.getPrimaryKey()).isNotNull();
        Assertions.assertThat((Collection)testInstance.getPrimaryKey().getColumns()).containsExactly(new Object[]{id, subId});
    }

    @Test
    void getColumnsPrimaryKey() {
        Table testInstance = new Table("toto");
        Assertions.assertThat((Object)testInstance.getPrimaryKey()).isNull();
        Column dummyColumn = testInstance.addColumn("dummyColumn", String.class);
        Column id = testInstance.addColumn("id", Long.TYPE).primaryKey();
        Assertions.assertThat((Collection)testInstance.getPrimaryKey().getColumns()).containsExactly(new Object[]{id});
        Assertions.assertThat((Collection)testInstance.getColumnsNoPrimaryKey()).isEqualTo((Object)Arrays.asHashSet((Object[])new Column[]{dummyColumn}));
    }

    @Test
    void addForeignKey() {
        Table testInstance1 = new Table("toto");
        Column tataId = testInstance1.addColumn("tataId", Integer.class);
        Table testInstance2 = new Table("tata");
        Column id = testInstance2.addColumn("id", Integer.class);
        ForeignKey createdFK = testInstance1.addForeignKey("XX", tataId, id);
        Assertions.assertThat((String)createdFK.getName()).isEqualTo("XX");
        Assertions.assertThat((Collection)createdFK.getColumns()).isEqualTo((Object)new KeepOrderSet((Object[])new Column[]{tataId}));
        Assertions.assertThat((Object)createdFK.getTable()).isEqualTo((Object)testInstance1);
        Assertions.assertThat((Collection)createdFK.getTargetColumns()).isEqualTo((Object)new KeepOrderSet((Object[])new Column[]{id}));
        Assertions.assertThat((Object)createdFK.getTargetTable()).isEqualTo((Object)testInstance2);
    }

    @Test
    void addForeignKey_withNamingFunction() {
        Table testInstance1 = new Table("toto");
        Column tataId = testInstance1.addColumn("tataId", Integer.class);
        Table testInstance2 = new Table("tata");
        Column id = testInstance2.addColumn("id", Integer.class);
        ForeignKey createdFK = testInstance1.addForeignKey((c1, c2) -> c1.getName() + "_" + c2.getName(), tataId, id);
        Assertions.assertThat((String)createdFK.getName()).isEqualTo("tataId_id");
        Assertions.assertThat((Collection)createdFK.getColumns()).isEqualTo((Object)new KeepOrderSet((Object[])new Column[]{tataId}));
        Assertions.assertThat((Object)createdFK.getTable()).isEqualTo((Object)testInstance1);
        Assertions.assertThat((Collection)createdFK.getTargetColumns()).isEqualTo((Object)new KeepOrderSet((Object[])new Column[]{id}));
        Assertions.assertThat((Object)createdFK.getTargetTable()).isEqualTo((Object)testInstance2);
    }
}

