/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.model.compositekey;

import java.util.Objects;
import org.codefilarete.stalactite.engine.model.compositekey.Person;

public class House {
    private Long id;
    private HouseId houseId;
    private Person owner;

    public House() {
    }

    public House(HouseId houseId) {
        this.houseId = houseId;
    }

    public Long getId() {
        return this.id;
    }

    public HouseId getHouseId() {
        return this.houseId;
    }

    public Person getOwner() {
        return this.owner;
    }

    public void setOwner(Person owner) {
        this.owner = owner;
    }

    public String toString() {
        return "House{id=" + this.id + ", houseId=" + this.houseId + '}';
    }

    public static class HouseId {
        private int number;
        private String street;
        private String zipCode;
        private String city;

        public HouseId() {
        }

        public HouseId(int number, String street, String zipCode, String city) {
            this.number = number;
            this.street = street;
            this.zipCode = zipCode;
            this.city = city;
        }

        public int getNumber() {
            return this.number;
        }

        public String getStreet() {
            return this.street;
        }

        public String getZipCode() {
            return this.zipCode;
        }

        public String getCity() {
            return this.city;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HouseId houseId = (HouseId)o;
            if (this.number != houseId.number) {
                return false;
            }
            if (!Objects.equals(this.street, houseId.street)) {
                return false;
            }
            if (!Objects.equals(this.zipCode, houseId.zipCode)) {
                return false;
            }
            return Objects.equals(this.city, houseId.city);
        }

        public int hashCode() {
            int result = this.number;
            result = 31 * result + (this.street != null ? this.street.hashCode() : 0);
            result = 31 * result + (this.zipCode != null ? this.zipCode.hashCode() : 0);
            result = 31 * result + (this.city != null ? this.city.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "HouseId{number=" + this.number + ", street='" + this.street + '\'' + ", zipCode='" + this.zipCode + '\'' + ", city='" + this.city + '\'' + '}';
        }
    }
}

