/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.autoconfigure;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.spring.autoconfigure.DialectCustomizer;
import org.codefilarete.stalactite.spring.autoconfigure.StalactiteAutoConfiguration;
import org.codefilarete.stalactite.spring.autoconfigure.StalactiteRepositoriesRegistrar;
import org.codefilarete.stalactite.spring.repository.StalactiteRepository;
import org.codefilarete.stalactite.spring.repository.StalactiteRepositoryFactoryBean;
import org.codefilarete.stalactite.spring.transaction.StalactitePlatformTransactionManager;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.DialectResolver;
import org.codefilarete.stalactite.sql.ServiceLoaderDialectResolver;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.task.TaskExecutionAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.type.AnnotationMetadata;

@AutoConfiguration(after={StalactiteAutoConfiguration.class, TaskExecutionAutoConfiguration.class})
@ConditionalOnBean(value={DataSource.class})
@ConditionalOnClass(value={StalactiteRepository.class})
@ConditionalOnMissingBean(value={StalactiteRepositoryFactoryBean.class})
@ConditionalOnProperty(prefix="spring.data.stalactite.repositories", name={"enabled"}, havingValue="true", matchIfMissing=true)
@Import(value={StalactiteRepositoriesImportSelector.class})
public class StalactiteRepositoriesAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public PersistenceContext persistenceContext(DataSource dataSource, Dialect dialect) {
        return new PersistenceContext(dataSource, dialect);
    }

    @Bean
    @ConditionalOnMissingBean
    public Dialect dialect(DialectResolver dialectResolver, DataSource dataSource, ObjectProvider<DialectCustomizer> dialectCustomizer) throws SQLException {
        Dialect dialect;
        try (Connection connection = dataSource.getConnection();){
            dialect = dialectResolver.determineDialect(connection);
        }
        ((DialectCustomizer)dialectCustomizer.getIfAvailable()).customize(dialect);
        return dialect;
    }

    @Bean
    @ConditionalOnMissingBean
    public DialectResolver dialectResolver() {
        return new ServiceLoaderDialectResolver();
    }

    @Bean
    @ConditionalOnMissingBean
    public StalactitePlatformTransactionManager stalactitePlatformTransactionManager(DataSource dataSource) {
        return new StalactitePlatformTransactionManager(dataSource);
    }

    static class StalactiteRepositoriesImportSelector
    implements ImportSelector {
        StalactiteRepositoriesImportSelector() {
        }

        public String[] selectImports(AnnotationMetadata importingClassMetadata) {
            return new String[]{StalactiteRepositoriesRegistrar.class.getName()};
        }
    }
}

