/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.result;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.stalactite.sql.result.InMemoryResultSet;
import org.codefilarete.stalactite.sql.result.ResultSetRowAssembler;
import org.codefilarete.stalactite.sql.result.ResultSetRowTransformer;
import org.codefilarete.stalactite.sql.result.ResultSetRowTransformerTest;
import org.codefilarete.stalactite.sql.result.SimpleBeanCache;
import org.codefilarete.stalactite.sql.result.WholeResultSetTransformer;
import org.codefilarete.stalactite.sql.statement.binder.DefaultResultSetReaders;
import org.codefilarete.tool.ThreadLocals;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.Maps;
import org.codefilarete.tool.function.Functions;
import org.codefilarete.tool.trace.ModifiableInt;
import org.danekja.java.util.function.serializable.SerializableFunction;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class WholeResultSetTransformerTest {
    WholeResultSetTransformerTest() {
    }

    @Test
    void transform_invokedOnEachRow_returnsSameBeanInstanceIfKeyColumnContainsSameValue() throws SQLException {
        String chickenInstantiationColumnName = "chickenName";
        String leftFeatherColorColumnName = "leftFeatherColor";
        WholeResultSetTransformer testInstance = new WholeResultSetTransformer(Chicken.class, chickenInstantiationColumnName, DefaultResultSetReaders.STRING_READER, (SerializableFunction & Serializable)x$0 -> new Chicken((String)x$0));
        testInstance.add(leftFeatherColorColumnName, DefaultResultSetReaders.STRING_READER, (chicken, colorName) -> chicken.getLeftWing().add(new Feather(new FeatherColor((String)colorName))));
        String keyColumnValue = "rooster";
        InMemoryResultSet resultSet = new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingHashMap[]{Maps.forHashMap(String.class, Object.class).add((Object)chickenInstantiationColumnName, (Object)keyColumnValue).add((Object)"leftFeatherNumber", (Object)1).add((Object)leftFeatherColorColumnName, (Object)"red"), Maps.forHashMap(String.class, Object.class).add((Object)chickenInstantiationColumnName, (Object)keyColumnValue).add((Object)"leftFeatherNumber", (Object)1).add((Object)leftFeatherColorColumnName, (Object)"black")}));
        ThreadLocals.doWithThreadLocal((ThreadLocal)WholeResultSetTransformer.CURRENT_BEAN_CACHE, SimpleBeanCache::new, () -> {
            resultSet.next();
            Chicken result1 = (Chicken)testInstance.transform((ResultSet)resultSet);
            Assertions.assertThat((String)result1.getName()).isEqualTo("rooster");
            Assertions.assertThat(result1.getLeftWing().getFeathers()).extracting(Functions.link(Feather::getColor, FeatherColor::getName)).containsExactly((Object[])new String[]{"red"});
            resultSet.next();
            Chicken result2 = (Chicken)testInstance.transform((ResultSet)resultSet);
            Assertions.assertThat((Object)result2).isSameAs((Object)result1);
            Assertions.assertThat(result1.getLeftWing().getFeathers()).extracting(Functions.link(Feather::getColor, FeatherColor::getName)).containsExactly((Object[])new String[]{"red", "black"});
        });
    }

    @Test
    void transform_invokedOnEachRow_returnsSameBeanInstanceIfKeyColumnContainsSameValue_asWellAsForRelation() throws SQLException {
        String chickenInstantiationColumnName = "chickenName";
        String leftFeatherColorColumnName = "leftFeatherColor";
        String rightFeatherColorColumnName = "rightFeatherColor";
        WholeResultSetTransformer testInstance = new WholeResultSetTransformer(Chicken.class, chickenInstantiationColumnName, DefaultResultSetReaders.STRING_READER, (SerializableFunction & Serializable)x$0 -> new Chicken((String)x$0));
        testInstance.add(leftFeatherColorColumnName, DefaultResultSetReaders.STRING_READER, FeatherColor.class, FeatherColor::new, (chicken, color) -> {
            if (color != null) {
                chicken.getLeftWing().add(new Feather((FeatherColor)color));
            }
        });
        testInstance.add(rightFeatherColorColumnName, DefaultResultSetReaders.STRING_READER, FeatherColor.class, FeatherColor::new, (chicken, color) -> {
            if (color != null) {
                chicken.getRightWing().add(new Feather((FeatherColor)color));
            }
        });
        String keyColumnValue = "rooster";
        InMemoryResultSet resultSet = new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingHashMap[]{Maps.forHashMap(String.class, Object.class).add((Object)chickenInstantiationColumnName, (Object)keyColumnValue).add((Object)leftFeatherColorColumnName, (Object)"red").add((Object)rightFeatherColorColumnName, null), Maps.forHashMap(String.class, Object.class).add((Object)chickenInstantiationColumnName, (Object)keyColumnValue).add((Object)leftFeatherColorColumnName, (Object)"black").add((Object)rightFeatherColorColumnName, null), Maps.forHashMap(String.class, Object.class).add((Object)chickenInstantiationColumnName, (Object)keyColumnValue).add((Object)leftFeatherColorColumnName, null).add((Object)rightFeatherColorColumnName, (Object)"black")}));
        ThreadLocals.doWithThreadLocal((ThreadLocal)WholeResultSetTransformer.CURRENT_BEAN_CACHE, SimpleBeanCache::new, () -> {
            resultSet.next();
            Chicken result1 = (Chicken)testInstance.transform((ResultSet)resultSet);
            Assertions.assertThat((String)result1.getName()).isEqualTo("rooster");
            Assertions.assertThat(result1.getLeftWing().getFeathers()).extracting(Functions.link(Feather::getColor, FeatherColor::getName)).containsExactly((Object[])new String[]{"red"});
            resultSet.next();
            Chicken result2 = (Chicken)testInstance.transform((ResultSet)resultSet);
            Assertions.assertThat((Object)result2).isSameAs((Object)result1);
            Assertions.assertThat(result1.getLeftWing().getFeathers()).extracting(Functions.link(Feather::getColor, FeatherColor::getName)).containsExactly((Object[])new String[]{"red", "black"});
            resultSet.next();
            Chicken result3 = (Chicken)testInstance.transform((ResultSet)resultSet);
            Assertions.assertThat((Object)result3).isSameAs((Object)result1);
            Assertions.assertThat(result1.getRightWing().getFeathers()).extracting(Functions.link(Feather::getColor, FeatherColor::getName)).containsExactly((Object[])new String[]{"black"});
            Function colorNameAccessor = Functions.link(Feather::getColor, FeatherColor::getName);
            Map leftWingFeatherColors = Iterables.map(result1.getLeftWing().getFeathers(), (Function)colorNameAccessor, Feather::getColor);
            Map rightWingFeatherColors = Iterables.map(result1.getRightWing().getFeathers(), (Function)colorNameAccessor, Feather::getColor);
            Assertions.assertThat(rightWingFeatherColors.get("black")).isSameAs(leftWingFeatherColors.get("black"));
        });
    }

    @Test
    void transform_withInnerClass() throws SQLException {
        String wingInstantiationColumnName = "wingName";
        String leftFeatherColorColumnName = "featherColor";
        WholeResultSetTransformer testInstance = new WholeResultSetTransformer(WingInner.class, wingInstantiationColumnName, DefaultResultSetReaders.STRING_READER, WingInner::new);
        testInstance.add(leftFeatherColorColumnName, DefaultResultSetReaders.STRING_READER, (wing, colorName) -> {
            WingInner wingInner = wing;
            wingInner.getClass();
            wingInner.new WingInner.FeatherInner((String)colorName);
        });
        InMemoryResultSet resultSet = new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingHashMap[]{Maps.forHashMap(String.class, Object.class).add((Object)wingInstantiationColumnName, (Object)"left").add((Object)leftFeatherColorColumnName, (Object)"red"), Maps.forHashMap(String.class, Object.class).add((Object)wingInstantiationColumnName, (Object)"left").add((Object)leftFeatherColorColumnName, (Object)"black")}));
        ThreadLocals.doWithThreadLocal((ThreadLocal)WholeResultSetTransformer.CURRENT_BEAN_CACHE, SimpleBeanCache::new, () -> {
            resultSet.next();
            WingInner result1 = (WingInner)testInstance.transform((ResultSet)resultSet);
            Assertions.assertThat((String)result1.getSide()).isEqualTo("left");
            Assertions.assertThat(result1.getFeathers()).extracting(WingInner.FeatherInner::getColor).containsExactly((Object[])new String[]{"red"});
            resultSet.next();
            WingInner result2 = (WingInner)testInstance.transform((ResultSet)resultSet);
            Assertions.assertThat((Object)result2).isSameAs((Object)result1);
            Assertions.assertThat(result1.getFeathers()).extracting(WingInner.FeatherInner::getColor).containsExactly((Object[])new String[]{"red", "black"});
        });
    }

    @Test
    void transformAll_returnsSameBeanInstanceIfKeyColumnContainsSameValue_asWellAsForRelation() {
        String chickenInstantiationColumnName = "chickenName";
        String leftFeatherColorColumnName = "leftFeatherColor";
        String rightFeatherColorColumnName = "rightFeatherColor";
        WholeResultSetTransformer testInstance = new WholeResultSetTransformer(Chicken.class, chickenInstantiationColumnName, DefaultResultSetReaders.STRING_READER, (SerializableFunction & Serializable)x$0 -> new Chicken((String)x$0));
        testInstance.add(leftFeatherColorColumnName, DefaultResultSetReaders.STRING_READER, FeatherColor.class, FeatherColor::new, (chicken, color) -> {
            if (color != null) {
                chicken.getLeftWing().add(new Feather((FeatherColor)color));
            }
        });
        testInstance.add(rightFeatherColorColumnName, DefaultResultSetReaders.STRING_READER, FeatherColor.class, FeatherColor::new, (chicken, color) -> {
            if (color != null) {
                chicken.getRightWing().add(new Feather((FeatherColor)color));
            }
        });
        InMemoryResultSet resultSet = new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingHashMap[]{Maps.forHashMap(String.class, Object.class).add((Object)chickenInstantiationColumnName, (Object)"rooster").add((Object)leftFeatherColorColumnName, (Object)"red").add((Object)rightFeatherColorColumnName, null), Maps.forHashMap(String.class, Object.class).add((Object)chickenInstantiationColumnName, (Object)"rooster").add((Object)leftFeatherColorColumnName, (Object)"black").add((Object)rightFeatherColorColumnName, null), Maps.forHashMap(String.class, Object.class).add((Object)chickenInstantiationColumnName, (Object)"rooster").add((Object)leftFeatherColorColumnName, null).add((Object)rightFeatherColorColumnName, (Object)"black")}));
        Set result = testInstance.transformAll((ResultSet)resultSet);
        Assertions.assertThat((int)result.size()).isEqualTo(1);
        Chicken rooster = (Chicken)Iterables.first((Iterable)result);
        Assertions.assertThat((String)rooster.getName()).isEqualTo("rooster");
        Assertions.assertThat(rooster.getLeftWing().getFeathers()).extracting(Functions.link(Feather::getColor, FeatherColor::getName)).containsExactly((Object[])new String[]{"red", "black"});
        Assertions.assertThat(rooster.getRightWing().getFeathers()).extracting(Functions.link(Feather::getColor, FeatherColor::getName)).containsExactly((Object[])new String[]{"black"});
        Function colorNameAccessor = Functions.link(Feather::getColor, FeatherColor::getName);
        Map leftWingFeatherColors = Iterables.map(rooster.getLeftWing().getFeathers(), (Function)colorNameAccessor, Feather::getColor);
        Map rightWingFeatherColors = Iterables.map(rooster.getRightWing().getFeathers(), (Function)colorNameAccessor, Feather::getColor);
        Assertions.assertThat(rightWingFeatherColors.get("black")).isSameAs(leftWingFeatherColors.get("black"));
    }

    @Test
    void transformAll_withAccumulator_testToRetrieveASingleColumn() {
        String chickenInstantiationColumnName = "chickenName";
        WholeResultSetTransformer testInstance = new WholeResultSetTransformer(String.class, chickenInstantiationColumnName, DefaultResultSetReaders.STRING_READER, SerializableFunction.identity());
        InMemoryResultSet resultSet = new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingHashMap[]{Maps.forHashMap(String.class, Object.class).add((Object)chickenInstantiationColumnName, (Object)"rooster1"), Maps.forHashMap(String.class, Object.class).add((Object)chickenInstantiationColumnName, (Object)"rooster2"), Maps.forHashMap(String.class, Object.class).add((Object)chickenInstantiationColumnName, (Object)"rooster1")}));
        List result = (List)testInstance.transformAll((ResultSet)resultSet, Accumulators.toList());
        Assertions.assertThat((List)result).containsExactlyInAnyOrder((Object[])new String[]{"rooster1", "rooster2", "rooster1"});
    }

    @Test
    void transformAll_withCollector_testToRetrieveASingleColumn() {
        String chickenInstantiationColumnName = "chickenName";
        WholeResultSetTransformer testInstance = new WholeResultSetTransformer(String.class, chickenInstantiationColumnName, DefaultResultSetReaders.STRING_READER, SerializableFunction.identity());
        InMemoryResultSet resultSet = new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingHashMap[]{Maps.forHashMap(String.class, Object.class).add((Object)chickenInstantiationColumnName, (Object)"rooster1"), Maps.forHashMap(String.class, Object.class).add((Object)chickenInstantiationColumnName, (Object)"rooster2"), Maps.forHashMap(String.class, Object.class).add((Object)chickenInstantiationColumnName, (Object)"rooster1")}));
        List result = (List)testInstance.transformAll((ResultSet)resultSet, Accumulators.toList());
        Assertions.assertThat((List)result).containsExactlyInAnyOrder((Object[])new String[]{"rooster1", "rooster2", "rooster1"});
    }

    @Test
    void transformAll_withCollector_returnsSameBeanInstanceIfKeyColumnContainsSameValue_asWellAsForRelation() {
        String chickenInstantiationColumnName = "chickenName";
        String leftFeatherColorColumnName = "leftFeatherColor";
        String rightFeatherColorColumnName = "rightFeatherColor";
        WholeResultSetTransformer testInstance = new WholeResultSetTransformer(Chicken.class, chickenInstantiationColumnName, DefaultResultSetReaders.STRING_READER, (SerializableFunction & Serializable)x$0 -> new Chicken((String)x$0));
        testInstance.add(leftFeatherColorColumnName, DefaultResultSetReaders.STRING_READER, FeatherColor.class, FeatherColor::new, (chicken, color) -> {
            if (color != null) {
                chicken.getLeftWing().add(new Feather((FeatherColor)color));
            }
        });
        testInstance.add(rightFeatherColorColumnName, DefaultResultSetReaders.STRING_READER, FeatherColor.class, FeatherColor::new, (chicken, color) -> {
            if (color != null) {
                chicken.getRightWing().add(new Feather((FeatherColor)color));
            }
        });
        InMemoryResultSet resultSet = new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingHashMap[]{Maps.forHashMap(String.class, Object.class).add((Object)chickenInstantiationColumnName, (Object)"rooster1").add((Object)leftFeatherColorColumnName, (Object)"red").add((Object)rightFeatherColorColumnName, null), Maps.forHashMap(String.class, Object.class).add((Object)chickenInstantiationColumnName, (Object)"rooster1").add((Object)leftFeatherColorColumnName, (Object)"black").add((Object)rightFeatherColorColumnName, null), Maps.forHashMap(String.class, Object.class).add((Object)chickenInstantiationColumnName, (Object)"rooster2").add((Object)leftFeatherColorColumnName, (Object)"brown").add((Object)rightFeatherColorColumnName, null), Maps.forHashMap(String.class, Object.class).add((Object)chickenInstantiationColumnName, (Object)"rooster1").add((Object)leftFeatherColorColumnName, null).add((Object)rightFeatherColorColumnName, (Object)"black")}));
        List result = (List)testInstance.transformAll((ResultSet)resultSet, Accumulators.toList());
        Assertions.assertThat((int)result.size()).isEqualTo(4);
        Chicken rooster1 = (Chicken)result.get(0);
        Assertions.assertThat((String)rooster1.getName()).isEqualTo("rooster1");
        Assertions.assertThat(rooster1.getLeftWing().getFeathers()).extracting(Functions.link(Feather::getColor, FeatherColor::getName)).containsExactly((Object[])new String[]{"red", "black"});
        Assertions.assertThat(rooster1.getRightWing().getFeathers()).extracting(Functions.link(Feather::getColor, FeatherColor::getName)).containsExactly((Object[])new String[]{"black"});
        Function colorNameAccessor = Functions.link(Feather::getColor, FeatherColor::getName);
        Map leftWingFeatherColors = Iterables.map(rooster1.getLeftWing().getFeathers(), (Function)colorNameAccessor, Feather::getColor);
        Map rightWingFeatherColors = Iterables.map(rooster1.getRightWing().getFeathers(), (Function)colorNameAccessor, Feather::getColor);
        Assertions.assertThat(rightWingFeatherColors.get("black")).isSameAs(leftWingFeatherColors.get("black"));
        Chicken rooster2 = (Chicken)result.get(2);
        Assertions.assertThat((String)rooster2.getName()).isEqualTo("rooster2");
        Assertions.assertThat(rooster2.getLeftWing().getFeathers()).extracting(Functions.link(Feather::getColor, FeatherColor::getName)).containsExactly((Object[])new String[]{"brown"});
    }

    static Object[][] testTransform_withReuse() {
        return new Object[][]{{new ResultSetRowTransformer(FeatherColor.class, "featherColor", DefaultResultSetReaders.STRING_READER, FeatherColor::new)}};
    }

    @ParameterizedTest
    @MethodSource(value={"testTransform_withReuse"})
    void transform_copyWithAliases(ResultSetRowTransformer<FeatherColor, String> featherColorTestInstance) {
        String chickenInstantiationColumnName = "chickenName";
        String leftFeatherColorColumnName = "leftFeatherColor";
        String rightFeatherColorColumnName = "rightFeatherColor";
        WholeResultSetTransformer testInstance = new WholeResultSetTransformer(Chicken.class, chickenInstantiationColumnName, DefaultResultSetReaders.STRING_READER, (SerializableFunction & Serializable)x$0 -> new Chicken((String)x$0));
        BeanRelationFixer leftChickenFeatherColorCombiner = (chicken, color) -> chicken.getLeftWing().add(new Feather((FeatherColor)color));
        BeanRelationFixer rightChickenFeatherColorCombiner = (chicken, color) -> chicken.getRightWing().add(new Feather((FeatherColor)color));
        Maps.ChainingHashMap leftColumnMapping = Maps.forHashMap(String.class, String.class).add((Object)"featherColor", (Object)leftFeatherColorColumnName);
        Maps.ChainingHashMap rightColumnMapping = Maps.forHashMap(String.class, String.class).add((Object)"featherColor", (Object)rightFeatherColorColumnName);
        testInstance.add(leftChickenFeatherColorCombiner, featherColorTestInstance.copyWithAliases((Map)leftColumnMapping));
        testInstance.add(rightChickenFeatherColorCombiner, featherColorTestInstance.copyWithAliases((Map)rightColumnMapping));
        final String sneakyFeatherColorColumnName = "sneakyFeatherColor";
        ResultSetRowAssembler<Chicken> rawAssembler = new ResultSetRowAssembler<Chicken>(){

            public void assemble(Chicken rootBean, ResultSet resultSet) throws SQLException {
                rootBean.addLeftFeather(new FeatherColor(resultSet.getString(sneakyFeatherColorColumnName)));
            }

            public ResultSetRowAssembler<Chicken> copyWithAliases(Function<String, String> columnMapping) {
                return (rootBean, resultSet) -> rootBean.addLeftFeather(new FeatherColor(resultSet.getString((String)columnMapping.apply(sneakyFeatherColorColumnName))));
            }
        };
        testInstance.add((ResultSetRowAssembler)rawAssembler);
        Function<String, String> translatingColumnFunction = s -> "_" + s + "_";
        testInstance = testInstance.copyWithAliases(translatingColumnFunction);
        InMemoryResultSet resultSet = new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingHashMap[]{Maps.forHashMap(String.class, Object.class).add((Object)translatingColumnFunction.apply(chickenInstantiationColumnName), (Object)"rooster").add((Object)translatingColumnFunction.apply(leftFeatherColorColumnName), (Object)"red").add((Object)translatingColumnFunction.apply(rightFeatherColorColumnName), null).add((Object)translatingColumnFunction.apply(sneakyFeatherColorColumnName), (Object)"pink"), Maps.forHashMap(String.class, Object.class).add((Object)translatingColumnFunction.apply(chickenInstantiationColumnName), (Object)"rooster").add((Object)translatingColumnFunction.apply(leftFeatherColorColumnName), (Object)"black").add((Object)translatingColumnFunction.apply(rightFeatherColorColumnName), null).add((Object)translatingColumnFunction.apply(sneakyFeatherColorColumnName), (Object)"pink"), Maps.forHashMap(String.class, Object.class).add((Object)translatingColumnFunction.apply(chickenInstantiationColumnName), (Object)"rooster").add((Object)translatingColumnFunction.apply(leftFeatherColorColumnName), null).add((Object)translatingColumnFunction.apply(rightFeatherColorColumnName), (Object)"black").add((Object)translatingColumnFunction.apply(sneakyFeatherColorColumnName), (Object)"pink")}));
        Set result = testInstance.transformAll((ResultSet)resultSet);
        Assertions.assertThat((int)result.size()).isEqualTo(1);
        Chicken rooster = (Chicken)Iterables.first((Iterable)result);
        Assertions.assertThat((String)rooster.getName()).isEqualTo("rooster");
        Assertions.assertThat(rooster.getLeftWing().getFeathers()).extracting(Functions.link(Feather::getColor, FeatherColor::getName)).containsExactly((Object[])new String[]{"red", "pink", "black", "pink", "pink"});
        Assertions.assertThat(rooster.getRightWing().getFeathers()).extracting(Functions.link(Feather::getColor, FeatherColor::getName)).containsExactly((Object[])new String[]{"black"});
        Function colorNameAccessor = Functions.link(Feather::getColor, FeatherColor::getName);
        Map leftWingFeatherColors = Iterables.map(rooster.getLeftWing().getFeathers(), (Function)colorNameAccessor, Feather::getColor);
        Map rightWingFeatherColors = Iterables.map(rooster.getRightWing().getFeathers(), (Function)colorNameAccessor, Feather::getColor);
        Assertions.assertThat(rightWingFeatherColors.get("black")).isSameAs(leftWingFeatherColors.get("black"));
    }

    @Test
    void copyFor() {
        String chickenInstantiationColumnName = "chickenName";
        String leftFeatherColorColumnName = "leftFeatherColor";
        String rightFeatherColorColumnName = "rightFeatherColor";
        WholeResultSetTransformer testInstance = new WholeResultSetTransformer(Chicken.class, chickenInstantiationColumnName, DefaultResultSetReaders.STRING_READER, (SerializableFunction & Serializable)x$0 -> new Chicken((String)x$0));
        testInstance.add(leftFeatherColorColumnName, DefaultResultSetReaders.STRING_READER, FeatherColor.class, FeatherColor::new, (chicken, color) -> {
            if (color != null) {
                chicken.getLeftWing().add(new Feather((FeatherColor)color));
            }
        });
        testInstance.add(rightFeatherColorColumnName, DefaultResultSetReaders.STRING_READER, FeatherColor.class, FeatherColor::new, (chicken, color) -> {
            if (color != null) {
                chicken.getRightWing().add(new Feather((FeatherColor)color));
            }
        });
        testInstance.add((rootBean, resultSet) -> rootBean.addLeftFeather(new FeatherColor("pink")), WholeResultSetTransformer.AssemblyPolicy.ON_EACH_ROW);
        testInstance.add((rootBean, resultSet) -> rootBean.addLeftFeather(new FeatherColor("yellow")), WholeResultSetTransformer.AssemblyPolicy.ONCE_PER_BEAN);
        ModifiableInt headCreationCounter = new ModifiableInt();
        testInstance.add(Chicken::setHead, new ResultSetRowTransformer(Head.class, chickenInstantiationColumnName, DefaultResultSetReaders.STRING_READER, (SerializableFunction & Serializable)s -> {
            headCreationCounter.increment();
            return new Head();
        }));
        WholeResultSetTransformer testInstanceCopy = testInstance.copyFor(Rooster.class, (SerializableFunction & Serializable)x$0 -> new Rooster((String)x$0));
        testInstanceCopy.add("chicks", DefaultResultSetReaders.INTEGER_PRIMITIVE_READER, Rooster::setChickCount);
        InMemoryResultSet resultSet2 = new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingHashMap[]{Maps.forHashMap(String.class, Object.class).add((Object)chickenInstantiationColumnName, (Object)"rooster").add((Object)leftFeatherColorColumnName, (Object)"red").add((Object)rightFeatherColorColumnName, null).add((Object)"chicks", (Object)3), Maps.forHashMap(String.class, Object.class).add((Object)chickenInstantiationColumnName, (Object)"rooster").add((Object)leftFeatherColorColumnName, (Object)"black").add((Object)rightFeatherColorColumnName, null).add((Object)"chicks", (Object)3), Maps.forHashMap(String.class, Object.class).add((Object)chickenInstantiationColumnName, (Object)"rooster").add((Object)leftFeatherColorColumnName, null).add((Object)rightFeatherColorColumnName, (Object)"black").add((Object)"chicks", (Object)3)}));
        Set result = testInstanceCopy.transformAll((ResultSet)resultSet2);
        Assertions.assertThat((int)result.size()).isEqualTo(1);
        Assertions.assertThat((int)headCreationCounter.getValue()).isEqualTo(1);
        Rooster rooster = (Rooster)Iterables.first((Iterable)result);
        Assertions.assertThat((String)rooster.getName()).isEqualTo("rooster");
        Assertions.assertThat((int)rooster.getChickCount()).isEqualTo(3);
        Assertions.assertThat(rooster.getLeftWing().getFeathers()).extracting(Functions.link(Feather::getColor, FeatherColor::getName)).containsExactly((Object[])new String[]{"red", "pink", "yellow", "black", "pink", "pink"});
        Assertions.assertThat(rooster.getRightWing().getFeathers()).extracting(Functions.link(Feather::getColor, FeatherColor::getName)).containsExactly((Object[])new String[]{"black"});
        Function colorNameAccessor = Functions.link(Feather::getColor, FeatherColor::getName);
        Map leftWingFeatherColors = Iterables.map(rooster.getLeftWing().getFeathers(), (Function)colorNameAccessor, Feather::getColor);
        Map rightWingFeatherColors = Iterables.map(rooster.getRightWing().getFeathers(), (Function)colorNameAccessor, Feather::getColor);
        Assertions.assertThat(rightWingFeatherColors.get("black")).isSameAs(leftWingFeatherColors.get("black"));
    }

    @Test
    void transformAll_withRelationDefiningAssemblyPolicy() {
        String chickenInstantiationColumnName = "chickenName";
        WholeResultSetTransformer testInstance = new WholeResultSetTransformer(Chicken.class, chickenInstantiationColumnName, DefaultResultSetReaders.STRING_READER, (SerializableFunction & Serializable)x$0 -> new Chicken((String)x$0));
        testInstance.add((rootBean, resultSet) -> rootBean.addLeftFeather(new FeatherColor("pink")), WholeResultSetTransformer.AssemblyPolicy.ON_EACH_ROW);
        testInstance.add((rootBean, resultSet) -> rootBean.addLeftFeather(new FeatherColor("yellow")), WholeResultSetTransformer.AssemblyPolicy.ONCE_PER_BEAN);
        ModifiableInt headCreationCounter = new ModifiableInt();
        testInstance.add(Chicken::setHead, new ResultSetRowTransformer(Head.class, chickenInstantiationColumnName, DefaultResultSetReaders.STRING_READER, (SerializableFunction & Serializable)s -> {
            headCreationCounter.increment();
            return new Head();
        }));
        InMemoryResultSet resultSet2 = new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingHashMap[]{Maps.forHashMap(String.class, Object.class).add((Object)chickenInstantiationColumnName, (Object)"rooster"), Maps.forHashMap(String.class, Object.class).add((Object)chickenInstantiationColumnName, (Object)"rooster"), Maps.forHashMap(String.class, Object.class).add((Object)chickenInstantiationColumnName, (Object)"rooster")}));
        Set result = testInstance.transformAll((ResultSet)resultSet2);
        Assertions.assertThat((int)result.size()).isEqualTo(1);
        Assertions.assertThat((int)headCreationCounter.getValue()).isEqualTo(1);
        Chicken rooster = (Chicken)Iterables.first((Iterable)result);
        Assertions.assertThat((String)rooster.getName()).isEqualTo("rooster");
        Assertions.assertThat(rooster.getLeftWing().getFeathers()).extracting(Functions.link(Feather::getColor, FeatherColor::getName)).containsExactly((Object[])new String[]{"pink", "yellow", "pink", "pink"});
    }

    @Test
    void transformAll_withRowAssemblerForACollection() {
        WholeResultSetTransformer testInstance = new WholeResultSetTransformer(ResultSetRowTransformerTest.Person.class, "name", DefaultResultSetReaders.STRING_READER, ResultSetRowTransformerTest.Person::new);
        testInstance.add("address", DefaultResultSetReaders.STRING_READER, ResultSetRowTransformerTest.Person::getAddresses, ResultSetRowTransformerTest.Person::setAddresses, ArrayList::new);
        InMemoryResultSet resultSet = new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingHashMap[]{Maps.forHashMap(String.class, Object.class).add((Object)"name", (Object)"paul").add((Object)"address", (Object)"rue Vaugirard"), Maps.forHashMap(String.class, Object.class).add((Object)"name", (Object)"paul").add((Object)"address", (Object)"rue Menon")}));
        Set result = testInstance.transformAll((ResultSet)resultSet);
        Assertions.assertThat((String)((ResultSetRowTransformerTest.Person)Iterables.first((Iterable)result)).getName()).isEqualTo("paul");
        Assertions.assertThat(((ResultSetRowTransformerTest.Person)Iterables.first((Iterable)result)).getAddresses()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"rue Vaugirard", "rue Menon"}));
    }

    private static class Rooster
    extends Chicken {
        private int chickCount;

        private Rooster(String name) {
            super(name);
        }

        public int getChickCount() {
            return this.chickCount;
        }

        public void setChickCount(int chickCount) {
            this.chickCount = chickCount;
        }
    }

    static class WingInner {
        private String side;
        private List<FeatherInner> feathers = new ArrayList<FeatherInner>();

        WingInner(String side) {
            this.side = side;
        }

        public String getSide() {
            return this.side;
        }

        public void setSide(String side) {
            this.side = side;
        }

        private void add(FeatherInner feather) {
            this.feathers.add(feather);
        }

        public List<FeatherInner> getFeathers() {
            return this.feathers;
        }

        public class FeatherInner {
            private String color;

            public FeatherInner(String color) {
                this.color = color;
                WingInner.this.add(this);
            }

            public String getColor() {
                return this.color;
            }

            public void setColor(String color) {
                this.color = color;
            }

            public WingInner getWing() {
                return WingInner.this;
            }

            public String toString() {
                return "Feather{color=" + this.color + '}';
            }
        }
    }

    private static class Head {
        private Head() {
        }
    }

    private static class FeatherColor {
        private String name;

        public FeatherColor(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            return super.toString() + "{name='" + this.name + '\'' + '}';
        }
    }

    private static class Feather {
        private FeatherColor color;

        public Feather(FeatherColor color) {
            this.color = color;
        }

        public FeatherColor getColor() {
            return this.color;
        }

        public void setColor(FeatherColor color) {
            this.color = color;
        }

        public String toString() {
            return "Feather{color=" + this.color + '}';
        }
    }

    private static class Wing {
        private List<Feather> feathers = new ArrayList<Feather>();

        private Wing() {
        }

        public void add(Feather feather) {
            this.feathers.add(feather);
        }

        public List<Feather> getFeathers() {
            return this.feathers;
        }
    }

    private static class Chicken {
        private String name;
        private Wing leftWing = new Wing();
        private Wing rightWing = new Wing();
        private Head head;

        private Chicken(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Wing getLeftWing() {
            return this.leftWing;
        }

        public void addLeftFeather(FeatherColor color) {
            this.getLeftWing().add(new Feather(color));
        }

        public Wing getRightWing() {
            return this.rightWing;
        }

        public Head getHead() {
            return this.head;
        }

        public Chicken setHead(Head head) {
            this.head = head;
            return this;
        }
    }
}

