/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.ddl;

import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.ddl.SqlTypeRegistry;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class SqlTypeRegistryTest {
    SqlTypeRegistryTest() {
    }

    public static Object[][] getTypeName_column() {
        Table toto = new Table("toto");
        Column columnA = toto.addColumn("a", String.class);
        SqlTypeRegistry testInstance1 = new SqlTypeRegistry(new JavaTypeToSqlTypeMapping());
        testInstance1.put(String.class, "VARCHAR(255)");
        SqlTypeRegistry testInstance2 = new SqlTypeRegistry();
        testInstance2.put(columnA, "CLOB");
        SqlTypeRegistry testInstanceWithOverrideByColumn = new SqlTypeRegistry();
        testInstanceWithOverrideByColumn.put(String.class, "VARCHAR(255)");
        testInstanceWithOverrideByColumn.put(columnA, "CLOB");
        return new Object[][]{{testInstance1, columnA, "VARCHAR(255)"}, {testInstance2, columnA, "CLOB"}, {testInstanceWithOverrideByColumn, columnA, "CLOB"}};
    }

    @ParameterizedTest
    @MethodSource(value={"getTypeName_column"})
    void getTypeName_column(SqlTypeRegistry testInstance, Column column, String expected) {
        Assertions.assertThat((String)testInstance.getTypeName(column)).isEqualTo(expected);
    }

    @Test
    void getTypeName_columnWithNullType_exceptionIsThrown() {
        Table toto = new Table("toto");
        Assertions.assertThatExceptionOfType(NullPointerException.class).isThrownBy(() -> toto.addColumn("a", null));
    }
}

