/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.InnoDBLockRetryer;
import org.codefilarete.stalactite.sql.statement.SQLExecutionException;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.WriteOperation;
import org.codefilarete.tool.Retryer;
import org.codefilarete.tool.function.ThrowingBiFunction;

public class MySQLWriteOperation<ParamType>
extends WriteOperation<ParamType> {
    private final InnoDBLockRetryer retryer;
    private final ThrowingBiFunction<Connection, String, PreparedStatement, SQLException> statementProvider;

    public MySQLWriteOperation(SQLStatement<ParamType> sqlGenerator, ConnectionProvider connectionProvider, WriteOperation.RowCountListener rowCountListener, InnoDBLockRetryer retryer, ThrowingBiFunction<Connection, String, PreparedStatement, SQLException> statementProvider) {
        super(sqlGenerator, connectionProvider, rowCountListener);
        this.retryer = retryer;
        this.statementProvider = statementProvider;
    }

    public MySQLWriteOperation(SQLStatement<ParamType> sqlGenerator, ConnectionProvider connectionProvider, WriteOperation.RowCountListener rowCountListener, InnoDBLockRetryer retryer) {
        this(sqlGenerator, connectionProvider, rowCountListener, retryer, (ThrowingBiFunction<Connection, String, PreparedStatement, SQLException>)((ThrowingBiFunction)Connection::prepareStatement));
    }

    protected void prepareStatement(Connection connection) throws SQLException {
        this.preparedStatement = (PreparedStatement)this.statementProvider.apply((Object)connection, (Object)this.getSQL());
    }

    protected long[] doExecuteBatch() throws SQLException {
        try {
            return (long[])this.retryer.execute(this.preparedStatement::executeLargeBatch, this.getSQL());
        }
        catch (Retryer.RetryException e) {
            throw new SQLExecutionException(this.getSQL(), (Throwable)e);
        }
    }

    protected long doExecuteUpdate() throws SQLException {
        try {
            return (Long)this.retryer.execute(this.preparedStatement::executeLargeUpdate, this.getSQL());
        }
        catch (Retryer.RetryException e) {
            throw new SQLExecutionException(this.getSQL(), (Throwable)e);
        }
    }
}

