/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.load;

import java.util.Set;
import org.codefilarete.stalactite.mapping.ColumnedRow;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.RowTransformer;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Row;

public interface EntityInflater<C, I> {
    public Class<C> getEntityType();

    public I giveIdentifier(Row var1, ColumnedRow var2);

    public RowTransformer<C> copyTransformerWithAliases(ColumnedRow var1);

    public Set<Selectable<?>> getSelectableColumns();

    public static class EntityMappingAdapter<C, I, T extends Table<T>>
    implements EntityInflater<C, I> {
        private final EntityMapping<C, I, T> delegate;

        public EntityMappingAdapter(EntityMapping<C, I, T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Class<C> getEntityType() {
            return this.delegate.getClassToPersist();
        }

        @Override
        public I giveIdentifier(Row row, ColumnedRow columnedRow) {
            return (I)this.delegate.getIdMapping().getIdentifierAssembler().assemble(row, columnedRow);
        }

        @Override
        public RowTransformer<C> copyTransformerWithAliases(ColumnedRow columnedRow) {
            return this.delegate.copyTransformerWithAliases(columnedRow);
        }

        @Override
        public Set<Selectable<?>> getSelectableColumns() {
            return this.delegate.getSelectableColumns();
        }
    }
}

