/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.diff;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.engine.diff.AbstractDiff;
import org.codefilarete.stalactite.engine.diff.CollectionDiffer;
import org.codefilarete.stalactite.engine.diff.Diff;
import org.codefilarete.stalactite.engine.diff.IndexedDiff;
import org.codefilarete.stalactite.engine.diff.State;
import org.codefilarete.stalactite.engine.idprovider.LongProvider;
import org.codefilarete.stalactite.engine.model.Country;
import org.codefilarete.stalactite.id.Identified;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.function.Functions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class CollectionDifferTest {
    private static final Function<AbstractDiff<? extends Identified>, ? extends Identified> GET_SOURCE_INSTANCE = AbstractDiff::getSourceInstance;
    private static final Function<AbstractDiff<? extends Identified>, ? extends Identified> GET_REPLACING_INSTANCE = AbstractDiff::getReplacingInstance;
    private static final Function<AbstractDiff<? extends Identified>, State> GET_STATE = AbstractDiff::getState;
    private static final Function<AbstractDiff<? extends Identified>, Comparable> SOURCE_ID_GETTER = Functions.link(GET_SOURCE_INSTANCE, Identified::getId).andThen(statefulIdentifier -> (Comparable)statefulIdentifier.getSurrogate());
    private static final Function<AbstractDiff<? extends Identified>, Comparable> REPLACING_ID_GETTER = Functions.link(GET_REPLACING_INSTANCE, Identified::getId).andThen(statefulIdentifier -> (Comparable)statefulIdentifier.getSurrogate());
    private static final Comparator<AbstractDiff<? extends Identified>> STATE_COMPARATOR = Comparator.comparing(GET_STATE);
    private static final Comparator<AbstractDiff<? extends Identified>> STATE_THEN_ID_COMPARATOR = STATE_COMPARATOR.thenComparing(SOURCE_ID_GETTER, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(REPLACING_ID_GETTER, Comparator.nullsFirst(Comparator.naturalOrder()));

    private static String toString(Iterable<? extends AbstractDiff> diffs) {
        return Iterables.stream(diffs).map(CollectionDifferTest::toString).collect(Collectors.joining(", "));
    }

    private static String toString(AbstractDiff diff) {
        return "" + diff.getState() + " " + diff.getSourceInstance() + " vs " + diff.getReplacingInstance() + (diff instanceof IndexedDiff ? " [ " + ((IndexedDiff)diff).getSourceIndexes() + " vs " + ((IndexedDiff)diff).getReplacerIndexes() + " ]" : "");
    }

    static Object[][] diffSet_data() {
        TestData testData = new TestData();
        return new Object[][]{{Arrays.asHashSet((Object[])new Country[]{testData.country1, testData.country2, testData.country3}), Arrays.asHashSet((Object[])new Country[]{testData.country3Clone, testData.country4, testData.country5}), Arrays.asHashSet((Object[])new Diff[]{new Diff(State.ADDED, null, (Object)testData.country4), new Diff(State.ADDED, null, (Object)testData.country5), new Diff(State.REMOVED, (Object)testData.country1, null), new Diff(State.REMOVED, (Object)testData.country2, null), new Diff(State.HELD, (Object)testData.country3, (Object)testData.country3Clone)})}, {Arrays.asHashSet((Object[])new Object[0]), Arrays.asHashSet((Object[])new Country[]{testData.country1}), Arrays.asHashSet((Object[])new Diff[]{new Diff(State.ADDED, null, (Object)testData.country1)})}, {Arrays.asHashSet((Object[])new Country[]{testData.country1}), Arrays.asHashSet((Object[])new Object[0]), Arrays.asHashSet((Object[])new Diff[]{new Diff(State.REMOVED, (Object)testData.country1, null)})}, {Arrays.asHashSet((Object[])new Object[0]), Arrays.asHashSet((Object[])new Object[0]), Arrays.asHashSet((Object[])new Object[0])}};
    }

    @ParameterizedTest
    @MethodSource(value={"diffSet_data"})
    void diffSet(Set<Country> set1, Set<Country> set2, Set<Diff<Country>> expectedResult) {
        CollectionDiffer testInstance = new CollectionDiffer(Country::getId);
        KeepOrderSet diffs = testInstance.diff(set1, set2);
        TreeSet sortedExpectation = Arrays.asTreeSet(STATE_THEN_ID_COMPARATOR, expectedResult);
        TreeSet sortedResult = Arrays.asTreeSet(STATE_THEN_ID_COMPARATOR, (Collection)diffs);
        Assertions.assertThat((String)CollectionDifferTest.toString(sortedResult)).isEqualTo(CollectionDifferTest.toString(sortedExpectation));
    }

    static Object[][] diffList_data() {
        TestData testData = new TestData();
        return new Object[][]{{Arrays.asList((Object[])new Country[]{testData.country1, testData.country2, testData.country3}), Arrays.asList((Object[])new Country[]{testData.country2, testData.country1, testData.country3}), Arrays.asHashSet((Object[])new IndexedDiff[]{new IndexedDiff(State.HELD, (Object)testData.country1, (Object)testData.country1).addSourceIndex(1).addReplacerIndex(2), new IndexedDiff(State.HELD, (Object)testData.country2, (Object)testData.country2).addSourceIndex(2).addReplacerIndex(1), new IndexedDiff(State.HELD, (Object)testData.country3, (Object)testData.country3).addSourceIndex(3).addReplacerIndex(3)})}, {Arrays.asList((Object[])new Country[]{testData.country1}), Arrays.asList((Object[])new Country[]{testData.country1, testData.country2}), Arrays.asHashSet((Object[])new IndexedDiff[]{new IndexedDiff(State.HELD, (Object)testData.country1, (Object)testData.country1).addSourceIndex(1).addReplacerIndex(1), new IndexedDiff(State.ADDED, null, (Object)testData.country2).addReplacerIndex(2)})}, {Arrays.asList((Object[])new Country[]{testData.country1, testData.country2}), Arrays.asList((Object[])new Country[]{testData.country1}), Arrays.asHashSet((Object[])new IndexedDiff[]{new IndexedDiff(State.HELD, (Object)testData.country1, (Object)testData.country1).addSourceIndex(1).addReplacerIndex(1), new IndexedDiff(State.REMOVED, (Object)testData.country2, null).addSourceIndex(2)})}, {Arrays.asList((Object[])new Country[]{testData.country1, testData.country2, testData.country1}), Arrays.asList((Object[])new Country[]{testData.country1}), Arrays.asHashSet((Object[])new IndexedDiff[]{new IndexedDiff(State.HELD, (Object)testData.country1, (Object)testData.country1).addSourceIndex(1).addReplacerIndex(1), new IndexedDiff(State.REMOVED, (Object)testData.country2, null).addSourceIndex(2), new IndexedDiff(State.REMOVED, (Object)testData.country1, null).addSourceIndex(3)})}, {Arrays.asList((Object[])new Country[]{testData.country1, testData.country2, testData.country1}), Arrays.asList((Object[])new Country[]{testData.country1, testData.country1}), Arrays.asHashSet((Object[])new IndexedDiff[]{new IndexedDiff(State.HELD, (Object)testData.country1, (Object)testData.country1).addSourceIndex(1).addSourceIndex(3).addReplacerIndex(1).addReplacerIndex(2), new IndexedDiff(State.REMOVED, (Object)testData.country2, null).addSourceIndex(2)})}, {Arrays.asList((Object[])new Country[]{testData.country1, testData.country2, testData.country1}), Arrays.asList((Object[])new Country[]{testData.country2}), Arrays.asHashSet((Object[])new IndexedDiff[]{new IndexedDiff(State.REMOVED, (Object)testData.country1, null).addSourceIndex(1).addSourceIndex(3), new IndexedDiff(State.HELD, (Object)testData.country2, (Object)testData.country2).addSourceIndex(2).addReplacerIndex(1)})}, {Arrays.asList((Object[])new Country[]{testData.country1, testData.country2, testData.country1}), Arrays.asList((Object[])new Country[]{testData.country1, testData.country1, testData.country1, testData.country1}), Arrays.asHashSet((Object[])new IndexedDiff[]{new IndexedDiff(State.HELD, (Object)testData.country1, (Object)testData.country1).addSourceIndex(1).addSourceIndex(3).addReplacerIndex(1).addReplacerIndex(2), new IndexedDiff(State.ADDED, null, (Object)testData.country1).addReplacerIndex(3).addReplacerIndex(4), new IndexedDiff(State.REMOVED, (Object)testData.country2, null).addSourceIndex(2)})}, {Arrays.asList((Object[])new Country[]{testData.country1, testData.country2, testData.country1}), Arrays.asList((Object[])new Country[]{testData.country1, testData.country1, testData.country1, testData.country1, testData.country2, testData.country2}), Arrays.asHashSet((Object[])new IndexedDiff[]{new IndexedDiff(State.HELD, (Object)testData.country1, (Object)testData.country1).addSourceIndex(1).addSourceIndex(3).addReplacerIndex(1).addReplacerIndex(2), new IndexedDiff(State.ADDED, null, (Object)testData.country1).addReplacerIndex(3).addReplacerIndex(4), new IndexedDiff(State.HELD, (Object)testData.country2, (Object)testData.country2).addSourceIndex(2).addReplacerIndex(5), new IndexedDiff(State.ADDED, null, (Object)testData.country2).addReplacerIndex(6)})}, {Arrays.asList((Object[])new Object[0]), Arrays.asList((Object[])new Country[]{testData.country1}), Arrays.asHashSet((Object[])new IndexedDiff[]{new IndexedDiff(State.ADDED, null, (Object)testData.country1).addReplacerIndex(1)})}, {Arrays.asList((Object[])new Country[]{testData.country1}), Arrays.asList((Object[])new Object[0]), Arrays.asHashSet((Object[])new IndexedDiff[]{new IndexedDiff(State.REMOVED, (Object)testData.country1, null).addSourceIndex(1)})}, {Arrays.asList((Object[])new Object[0]), Arrays.asList((Object[])new Object[0]), Arrays.asHashSet((Object[])new Object[0])}};
    }

    @ParameterizedTest
    @MethodSource(value={"diffList_data"})
    void diffList(List<Country> set1, List<Country> set2, Set<IndexedDiff<Country>> expectedResult) {
        CollectionDiffer testInstance = new CollectionDiffer(Country::getId);
        KeepOrderSet diffs = testInstance.diffOrdered(set1, set2);
        TreeSet treeSet1 = Arrays.asTreeSet(STATE_THEN_ID_COMPARATOR, (Collection)diffs);
        TreeSet treeSet2 = Arrays.asTreeSet(STATE_THEN_ID_COMPARATOR, expectedResult);
        Assertions.assertThat((String)CollectionDifferTest.toString(treeSet1)).isEqualTo(CollectionDifferTest.toString(treeSet2));
    }

    @Test
    void diffList_withClone_cloneMustBeReplacingInstance() {
        TestData testData = new TestData();
        Country country1Clone = new Country(testData.country1.getId());
        country1Clone.setName(testData.country1.getName());
        List set1 = Arrays.asList((Object[])new Country[]{testData.country1, testData.country2, testData.country3});
        List set2 = Arrays.asList((Object[])new Country[]{testData.country2, country1Clone, testData.country3});
        CollectionDiffer testInstance = new CollectionDiffer(Country::getName);
        KeepOrderSet diffs = testInstance.diffOrdered((Collection)set1, (Collection)set2);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)diffs).usingElementComparator((countryIndexedDiffComputed, countryIndexedDiffExpected) -> countryIndexedDiffComputed.getState().equals((Object)countryIndexedDiffExpected.getState()) && countryIndexedDiffComputed.getSourceInstance() == countryIndexedDiffExpected.getSourceInstance() && countryIndexedDiffComputed.getReplacingInstance() == countryIndexedDiffExpected.getReplacingInstance() && countryIndexedDiffComputed.getSourceIndexes().equals(countryIndexedDiffExpected.getSourceIndexes()) && countryIndexedDiffComputed.getReplacerIndexes().equals(countryIndexedDiffExpected.getReplacerIndexes()) ? 0 : -1)).isEqualTo((Object)Arrays.asHashSet((Object[])new IndexedDiff[]{new IndexedDiff(State.HELD, (Object)testData.country1, (Object)country1Clone, (Set)Arrays.asHashSet((Object[])new Integer[]{1}), (Set)Arrays.asHashSet((Object[])new Integer[]{2})), new IndexedDiff(State.HELD, (Object)testData.country2, (Object)testData.country2, (Set)Arrays.asHashSet((Object[])new Integer[]{2}), (Set)Arrays.asHashSet((Object[])new Integer[]{1})), new IndexedDiff(State.HELD, (Object)testData.country3, (Object)testData.country3, (Set)Arrays.asHashSet((Object[])new Integer[]{3}), (Set)Arrays.asHashSet((Object[])new Integer[]{3}))}));
    }

    private static class TestData {
        private final LongProvider longProvider = new LongProvider();
        private final Country country1 = new Country((Long)this.longProvider.giveNewIdentifier());
        private final Country country2 = new Country((Long)this.longProvider.giveNewIdentifier());
        private final Country country3 = new Country((Long)this.longProvider.giveNewIdentifier());
        private final Country country3Clone = new Country(this.country3.getId());
        private final Country country4 = new Country((Long)this.longProvider.giveNewIdentifier());
        private final Country country5 = new Country((Long)this.longProvider.giveNewIdentifier());

        private TestData() {
            this.country1.setName("France");
            this.country2.setName("Spain");
            this.country3.setName("Italy");
            this.country3Clone.setName(this.country3.getName() + " changed");
            this.country4.setName("England");
            this.country5.setName("Germany");
        }
    }
}

