/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql;

import java.util.Collections;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.DDLTableGenerator;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.ddl.SqlTypeRegistry;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.statement.binder.PostgreSQLTypeMapping;

public class PostgreSQLDialect
extends Dialect {
    public PostgreSQLDialect() {
        super((JavaTypeToSqlTypeMapping)new PostgreSQLTypeMapping());
    }

    public DDLTableGenerator newDdlTableGenerator() {
        return new PostgreSQLDDLTableGenerator(this.getSqlTypeRegistry());
    }

    public boolean supportsTupleCondition() {
        return true;
    }

    public static class PostgreSQLDDLTableGenerator
    extends DDLTableGenerator {
        public PostgreSQLDDLTableGenerator(SqlTypeRegistry typeMapping) {
            super(typeMapping, new DMLNameProvider(Collections.emptyMap()));
        }

        protected String getSqlType(Column column) {
            String sqlType = column.isAutoGenerated() ? " SERIAL" : super.getSqlType(column);
            return sqlType;
        }
    }
}

