/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer;

import java.util.Map;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.stalactite.engine.ColumnOptions;
import org.codefilarete.stalactite.engine.EntityMappingConfiguration;
import org.codefilarete.stalactite.mapping.id.manager.AlreadyAssignedIdentifierManager;
import org.codefilarete.stalactite.mapping.id.manager.IdentifierInsertionManager;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;

public abstract class AbstractIdentification<C, I> {
    private final ReversibleAccessor<C, I> idAccessor;
    private final EntityMappingConfiguration<C, I> identificationDefiner;
    private final EntityMappingConfiguration.KeyMapping<C, I> keyLinkage;
    private IdentifierInsertionManager<C, I> insertionManager;
    private AlreadyAssignedIdentifierManager<C, I> fallbackInsertionManager;

    static <C, I> Identification<C, I> forSingleKey(EntityMappingConfiguration<C, I> identificationDefiner) {
        return new Identification(identificationDefiner, ((EntityMappingConfiguration.SingleKeyMapping)identificationDefiner.getKeyMapping()).getIdentifierPolicy());
    }

    static <C, I> CompositeKeyIdentification<C, I> forCompositeKey(EntityMappingConfiguration<C, I> identificationDefiner) {
        return new CompositeKeyIdentification(identificationDefiner);
    }

    private AbstractIdentification(EntityMappingConfiguration<C, I> identificationDefiner) {
        this.keyLinkage = identificationDefiner.getKeyMapping();
        this.idAccessor = identificationDefiner.getKeyMapping().getAccessor();
        this.identificationDefiner = identificationDefiner;
    }

    public EntityMappingConfiguration.KeyMapping<C, I> getKeyLinkage() {
        return this.keyLinkage;
    }

    public ReversibleAccessor<C, I> getIdAccessor() {
        return this.idAccessor;
    }

    public EntityMappingConfiguration<C, I> getIdentificationDefiner() {
        return this.identificationDefiner;
    }

    public IdentifierInsertionManager<C, I> getInsertionManager() {
        return this.insertionManager;
    }

    public AbstractIdentification<C, I> setInsertionManager(IdentifierInsertionManager<C, I> insertionManager) {
        this.insertionManager = insertionManager;
        return this;
    }

    public AlreadyAssignedIdentifierManager<C, I> getFallbackInsertionManager() {
        return this.fallbackInsertionManager;
    }

    public AbstractIdentification<C, I> setFallbackInsertionManager(AlreadyAssignedIdentifierManager<C, I> fallbackInsertionManager) {
        this.fallbackInsertionManager = fallbackInsertionManager;
        return this;
    }

    public static class CompositeKeyIdentification<C, I>
    extends AbstractIdentification<C, I> {
        private Map<ReversibleAccessor<I, Object>, Column<Table, Object>> compositeKeyMapping;

        private CompositeKeyIdentification(EntityMappingConfiguration<C, I> identificationDefiner) {
            super(identificationDefiner);
        }

        public Map<ReversibleAccessor<I, Object>, Column<Table, Object>> getCompositeKeyMapping() {
            return this.compositeKeyMapping;
        }

        public void setCompositeKeyMapping(Map<? extends ReversibleAccessor<I, Object>, ? extends Column<?, Object>> compositeKeyMapping) {
            this.compositeKeyMapping = compositeKeyMapping;
        }
    }

    public static class Identification<C, I>
    extends AbstractIdentification<C, I> {
        private final ColumnOptions.IdentifierPolicy<I> identifierPolicy;

        private Identification(EntityMappingConfiguration<C, I> identificationDefiner, ColumnOptions.IdentifierPolicy<I> identifierPolicy) {
            super(identificationDefiner);
            this.identifierPolicy = identifierPolicy;
        }

        public ColumnOptions.IdentifierPolicy<I> getIdentifierPolicy() {
            return this.identifierPolicy;
        }
    }
}

