/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.ddl.structure;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Database;
import org.codefilarete.stalactite.sql.ddl.structure.ForeignKey;
import org.codefilarete.stalactite.sql.ddl.structure.Index;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.UniqueConstraint;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.function.Predicates;

public class Table<SELF extends Table<SELF>>
implements Fromable {
    private final Database.Schema schema;
    private final String name;
    private final String absoluteName;
    private final KeepOrderSet<Column<SELF, Object>> columns = new KeepOrderSet();
    private PrimaryKey<SELF, ?> primaryKey;
    private final Set<Index> indexes = new HashSet<Index>();
    private final Set<UniqueConstraint> uniqueConstraints = new HashSet<UniqueConstraint>();
    private final Set<ForeignKey<SELF, ? extends Table<?>, ?>> foreignKeys = new HashSet();
    private final Map<String, Column<SELF, ?>> columnsPerName = new HashMap();
    private final int hashCode;

    public Table(String name) {
        this(null, name);
    }

    public Table(Database.Schema schema, String name) {
        this.schema = schema;
        this.name = name;
        this.absoluteName = (schema == null ? "" : schema.getName() + ".") + name;
        this.hashCode = name.toUpperCase().hashCode();
    }

    public Database.Schema getSchema() {
        return this.schema;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAbsoluteName() {
        return this.absoluteName;
    }

    public Set<Column<SELF, ?>> getColumns() {
        return Collections.unmodifiableSet(this.columns);
    }

    public Map<Column<SELF, ?>, String> getAliases() {
        HashMap result = new HashMap();
        this.columnsPerName.forEach((key, value) -> result.put(value, key));
        return Collections.unmodifiableMap(result);
    }

    public Set<Column<SELF, Object>> getColumnsNoPrimaryKey() {
        LinkedHashSet<Column<SELF, Object>> result = new LinkedHashSet<Column<SELF, Object>>(this.columns);
        result.removeAll((Collection)Nullable.nullable(this.getPrimaryKey()).map(PrimaryKey::getColumns).getOr((Object)new KeepOrderSet()));
        return result;
    }

    public <O> Column<SELF, O> addColumn(String name, Class<O> javaType) {
        return this.addertColumn(new Column<Table, O>(this, name, javaType));
    }

    public <O> Column<SELF, O> addColumn(String name, Class<O> javaType, Integer size) {
        return this.addertColumn(new Column<Table, O>(this, name, javaType, size));
    }

    private <O> Column<SELF, O> addertColumn(Column<SELF, O> column) {
        Column existingColumn = this.getColumn(column.getName());
        if (!(existingColumn == null || existingColumn.getJavaType().equals(column.getJavaType()) && Predicates.equalOrNull((Object)existingColumn.getSize(), (Object)column.getSize()))) {
            throw new IllegalArgumentException("Trying to add column '" + column.getName() + "' to '" + this.getAbsoluteName() + "' but it already exists with a different type : " + Table.typeToString(existingColumn) + " vs " + Table.typeToString(column));
        }
        if (existingColumn == null) {
            this.columns.add(column);
            this.columnsPerName.put(column.getName(), column);
            return column;
        }
        return existingColumn;
    }

    public Map<String, Column<SELF, Object>> mapColumnsOnName() {
        return new HashMap<String, Column<SELF, Object>>(this.columnsPerName);
    }

    public <C> Column<SELF, C> getColumn(String columnName) {
        return this.columnsPerName.get(columnName);
    }

    public Column<SELF, ?> findColumn(String columnName) {
        return this.getColumn(columnName);
    }

    public <ID> PrimaryKey<SELF, ID> getPrimaryKey() {
        if (this.primaryKey == null) {
            Set pkColumns = (Set)Iterables.collect(this.columns, Column::isPrimaryKey, Function.identity(), LinkedHashSet::new);
            this.primaryKey = pkColumns.isEmpty() ? null : new PrimaryKey(pkColumns);
        }
        return this.primaryKey;
    }

    public Set<Index> getIndexes() {
        return Collections.unmodifiableSet(this.indexes);
    }

    public Index addIndex(String name, Column<SELF, ?> column, Column<SELF, ?> ... columns) {
        Index newIndex = new Index(name, column, columns);
        this.indexes.add(newIndex);
        return newIndex;
    }

    public Set<ForeignKey<SELF, ?, ?>> getForeignKeys() {
        return Collections.unmodifiableSet(this.foreignKeys);
    }

    public <T extends Table<T>, I> ForeignKey<SELF, T, I> addForeignKey(BiFunction<Column<SELF, I>, Column<T, I>, String> namingFunction, Column<SELF, I> column, Column<T, I> targetColumn) {
        return this.addForeignKey(namingFunction.apply(column, targetColumn), column, targetColumn);
    }

    public <T extends Table<T>, I> ForeignKey<SELF, T, I> addForeignKey(String name, Column<SELF, I> column, Column<T, I> targetColumn) {
        return this.addssertForeignKey(new ForeignKey(name, column, targetColumn));
    }

    public <T extends Table<T>, I> ForeignKey<SELF, T, I> addForeignKey(String name, List<? extends Column<SELF, Object>> columns, List<? extends Column<T, Object>> targetColumns) {
        return this.addssertForeignKey(new ForeignKey(name, new KeepOrderSet(columns), new KeepOrderSet(targetColumns)));
    }

    public <T extends Table<T>, I> ForeignKey<SELF, T, I> addForeignKey(String name, Key<SELF, I> columns, Key<T, I> targetColumns) {
        ForeignKey foreignKey = new ForeignKey(name, columns.getColumns(), targetColumns.getColumns());
        return this.addssertForeignKey(foreignKey);
    }

    public <T extends Table<T>, I, K1 extends Key<SELF, I>, K2 extends Key<T, I>> ForeignKey<SELF, T, I> addForeignKey(BiFunction<K1, K2, String> namingFunction, K1 sourceColumns, K2 targetColumns) {
        ForeignKey foreignKey = new ForeignKey(namingFunction.apply(sourceColumns, targetColumns), sourceColumns.getColumns(), targetColumns.getColumns());
        return this.addssertForeignKey(foreignKey);
    }

    private <T extends Table<T>, I> ForeignKey<SELF, T, I> addssertForeignKey(ForeignKey<SELF, T, I> foreignKey) {
        ForeignKey<SELF, T, I> existingForeignKey = this.assertDoesNotExistOnSameName(foreignKey);
        if (existingForeignKey == null) {
            this.assertDoesNotExistOnSameColumns(foreignKey);
            this.foreignKeys.add(foreignKey);
            return foreignKey;
        }
        return existingForeignKey;
    }

    private <T extends Table<T>, I> ForeignKey<SELF, T, I> assertDoesNotExistOnSameName(ForeignKey<SELF, T, I> foreignKey) {
        ForeignKey existingForeignKey = (ForeignKey)Iterables.find(this.foreignKeys, fk -> fk.getName().equals(foreignKey.getName()));
        if (!(existingForeignKey == null || existingForeignKey.getColumns().equals(foreignKey.getColumns()) && existingForeignKey.getTargetColumns().equals(foreignKey.getTargetColumns()))) {
            throw new IllegalArgumentException("Trying to add a foreign key with same name than another with different columns : " + foreignKey.getName() + " " + Table.toString(existingForeignKey) + " vs " + Table.toString(foreignKey));
        }
        return existingForeignKey;
    }

    private <T extends Table<T>, I> ForeignKey<SELF, T, I> assertDoesNotExistOnSameColumns(ForeignKey<SELF, T, I> foreignKey) {
        ForeignKey existingForeignKeyWithSameColumns = (ForeignKey)Iterables.find(this.foreignKeys, fk -> fk.getColumns().equals(foreignKey.getColumns()));
        if (existingForeignKeyWithSameColumns != null && !existingForeignKeyWithSameColumns.getTargetColumns().equals(foreignKey.getTargetColumns())) {
            throw new IllegalArgumentException("A foreign key with same source columns but different referenced columns already exist : '" + existingForeignKeyWithSameColumns.getName() + "' <" + Table.toString(existingForeignKeyWithSameColumns) + "> vs wanted new one '" + foreignKey.getName() + "' <" + Table.toString(foreignKey) + ">");
        }
        return existingForeignKeyWithSameColumns;
    }

    public Set<UniqueConstraint> getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    public UniqueConstraint addUniqueConstraint(String name, Column<SELF, ?> column, Column<SELF, ?> ... columns) {
        UniqueConstraint newUniqueConstraint = new UniqueConstraint(name, column, columns);
        this.uniqueConstraints.add(newUniqueConstraint);
        return newUniqueConstraint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Table)) {
            return false;
        }
        Table table = (Table)o;
        return this.getName().equalsIgnoreCase(table.getName());
    }

    public int hashCode() {
        return this.hashCode;
    }

    private static String typeToString(Column column) {
        return Reflections.toString(column.getJavaType()) + (column.getSize() != null ? "(" + column.getSize() + ")" : "");
    }

    private static String toString(ForeignKey column) {
        StringAppender result = new StringAppender(){

            public StringAppender cat(Object s) {
                if (s instanceof Column) {
                    return super.cat((Object)((Column)s).getAbsoluteName());
                }
                return super.cat(s);
            }
        };
        result.ccat(column.getColumns(), (Object)", ").cat((Object)" -> ").ccat(column.getTargetColumns(), (Object)", ");
        return result.toString();
    }
}

