/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.ddl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.codefilarete.tool.bean.InterfaceIterator;
import org.codefilarete.tool.collection.Iterables;

public class JavaTypeToSqlTypeMapping {
    private final Map<Class, SortedMap<Integer, String>> javaTypeToSQLType = new HashMap<Class, SortedMap<Integer, String>>();
    private final Map<Class, String> defaultJavaTypeToSQLType = new HashMap<Class, String>();

    public void put(Class clazz, String sqlType) {
        this.defaultJavaTypeToSQLType.put(clazz, sqlType);
    }

    public void put(Class clazz, String sqlType, int size) {
        this.getSQLType(clazz).put(size, sqlType);
    }

    private SortedMap<Integer, String> getSQLType(Class clazz) {
        return this.javaTypeToSQLType.computeIfAbsent(clazz, k -> new TreeMap());
    }

    public JavaTypeToSqlTypeMapping with(Class clazz, String sqlType) {
        this.put(clazz, sqlType);
        return this;
    }

    public JavaTypeToSqlTypeMapping with(Class clazz, int size, String sqlType) {
        this.put(clazz, sqlType, size);
        return this;
    }

    public String getTypeName(Class javaType) {
        String type = this.defaultJavaTypeToSQLType.get(javaType);
        if (type == null) {
            if (javaType.isEnum()) {
                type = this.defaultJavaTypeToSQLType.get(Enum.class);
            } else {
                InterfaceIterator interfaceIterator = new InterfaceIterator(javaType);
                Stream<String> stream = Iterables.stream((Iterator)interfaceIterator).map(this.defaultJavaTypeToSQLType::get);
                type = stream.filter(Objects::nonNull).findFirst().orElse(null);
                if (type != null) {
                    return type;
                }
            }
        }
        return type;
    }

    public String getTypeName(Class javaType, Integer size) {
        if (size == null) {
            return this.getTypeName(javaType);
        }
        SortedMap<Integer, String> typeNames = this.getSQLType(javaType).tailMap(size);
        String typeName = (String)Iterables.firstValue(typeNames);
        typeName = typeName != null ? typeName.replace("$l", String.valueOf(size)) : this.getTypeName(javaType);
        return typeName;
    }
}

