/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.codefilarete.stalactite.engine.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.MappingEase;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.model.City;
import org.codefilarete.stalactite.engine.model.Country;
import org.codefilarete.stalactite.engine.runtime.ConfiguredPersister;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.OptimizedUpdatePersister;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.id.PersistedIdentifier;
import org.codefilarete.stalactite.id.StatefulIdentifier;
import org.codefilarete.stalactite.id.StatefulIdentifierAlreadyAssignedIdentifierPolicy;
import org.codefilarete.stalactite.query.ConfiguredEntityCriteria;
import org.codefilarete.stalactite.query.EntityGraphSelector;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.CurrentThreadConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.HSQLDBDialect;
import org.codefilarete.stalactite.sql.ddl.DDLDeployer;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.sql.test.HSQLDBInMemoryDataSource;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.function.Functions;
import org.junit.jupiter.api.Test;

class EntityGraphSelectExecutorTest {
    EntityGraphSelectExecutorTest() {
    }

    @Test
    void select() throws SQLException {
        CurrentThreadConnectionProvider connectionProvider = new CurrentThreadConnectionProvider((DataSource)new HSQLDBInMemoryDataSource());
        HSQLDBDialect dialect = new HSQLDBDialect();
        dialect.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        dialect.getSqlTypeRegistry().put(Identifier.class, "bigint");
        PersistenceContext persistenceContext = new PersistenceContext((ConnectionProvider)connectionProvider, (Dialect)dialect);
        OptimizedUpdatePersister persister = (OptimizedUpdatePersister)MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).mapOneToMany(Country::getCities, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName)).mappedBy(City::getCountry).build(persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(persistenceContext);
        ddlDeployer.deployDDL();
        Connection currentConnection = connectionProvider.giveConnection();
        currentConnection.prepareStatement("insert into Country(id, name) values(12, 'France')").execute();
        currentConnection.prepareStatement("insert into City(id, name, countryId) values(42, 'Paris', 12)").execute();
        currentConnection.prepareStatement("insert into City(id, name, countryId) values(43, 'Lyon', 12)").execute();
        currentConnection.prepareStatement("insert into City(id, name, countryId) values(44, 'Grenoble', 12)").execute();
        EntityGraphSelector testInstance = new EntityGraphSelector((ConfiguredPersister)persister, persister.getEntityJoinTree(), (ConnectionProvider)connectionProvider, (Dialect)dialect);
        ConfiguredEntityCriteria countryEntityCriteriaSupport = (ConfiguredEntityCriteria)persister.selectWhere(Country::getName, (ConditionalOperator)Operators.eq((Object)"France")).andMany(Country::getCities, City::getName, (ConditionalOperator)Operators.eq((Object)"Grenoble"));
        Country expectedCountry = new Country(new PersistedIdentifier<Long>(12L));
        expectedCountry.setName("France");
        City paris = new City(new PersistedIdentifier<Long>(42L));
        paris.setName("Paris");
        City lyon = new City(new PersistedIdentifier<Long>(43L));
        lyon.setName("Lyon");
        City grenoble = new City(new PersistedIdentifier<Long>(44L));
        grenoble.setName("Grenoble");
        expectedCountry.setCities(Arrays.asSet((Object[])new City[]{paris, lyon, grenoble}));
        Set select = persister.getPersisterListener().doWithSelectListener(Collections.emptyList(), () -> testInstance.select(countryEntityCriteriaSupport, fluentOrderByClause -> {}, limitAware -> {}));
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)Iterables.first((Iterable)select)).usingComparator(Comparator.comparing(Functions.chain(Country::getId, StatefulIdentifier::getSurrogate)))).isEqualTo((Object)expectedCountry)).usingComparator(Comparator.comparing(Country::getName))).isEqualTo((Object)expectedCountry);
    }

    @Test
    void select_emptyResult() {
        CurrentThreadConnectionProvider connectionProvider = new CurrentThreadConnectionProvider((DataSource)new HSQLDBInMemoryDataSource());
        HSQLDBDialect dialect = new HSQLDBDialect();
        dialect.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        dialect.getSqlTypeRegistry().put(Identifier.class, "bigint");
        PersistenceContext persistenceContext = new PersistenceContext((ConnectionProvider)connectionProvider, (Dialect)dialect);
        ConfiguredRelationalPersister persister = (ConfiguredRelationalPersister)MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).mapOneToMany(Country::getCities, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName)).mappedBy(City::getCountry).build(persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(persistenceContext);
        ddlDeployer.deployDDL();
        EntityPersister.ExecutableEntityQuery countryEntityCriteriaSupport = (EntityPersister.ExecutableEntityQuery)persister.selectWhere(Country::getName, (ConditionalOperator)Operators.eq((Object)"France")).andMany(Country::getCities, City::getName, (ConditionalOperator)Operators.eq((Object)"Grenoble"));
        Set select = (Set)countryEntityCriteriaSupport.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)select).isEmpty();
    }
}

