/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.runtime.AdvancedEntityPersister;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.EntityQueryCriteriaSupport;
import org.codefilarete.stalactite.engine.runtime.PolymorphicPersister;
import org.codefilarete.stalactite.engine.runtime.ProjectionQueryCriteriaSupport;
import org.codefilarete.stalactite.engine.runtime.RelationalEntityPersister;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.query.EntityCriteriaSupport;
import org.codefilarete.stalactite.query.EntitySelector;
import org.codefilarete.stalactite.query.model.Select;
import org.codefilarete.stalactite.sql.result.Accumulators;

public abstract class AbstractPolymorphismPersister<C, I>
implements ConfiguredRelationalPersister<C, I>,
PolymorphicPersister<C>,
AdvancedEntityPersister<C, I> {
    protected final Map<Class<C>, ConfiguredRelationalPersister<C, I>> subEntitiesPersisters;
    protected final ConfiguredRelationalPersister<C, I> mainPersister;
    protected final EntityCriteriaSupport<C> criteriaSupport;
    protected final EntitySelector<C, I> entitySelector;

    protected AbstractPolymorphismPersister(ConfiguredRelationalPersister<C, I> mainPersister, Map<? extends Class<C>, ? extends ConfiguredRelationalPersister<C, I>> subEntitiesPersisters, EntitySelector<C, I> entitySelector) {
        this.mainPersister = mainPersister;
        this.subEntitiesPersisters = subEntitiesPersisters;
        this.criteriaSupport = new EntityCriteriaSupport(mainPersister.getMapping());
        this.entitySelector = entitySelector;
    }

    @Override
    public RelationalEntityPersister.ExecutableEntityQueryCriteria<C, ?> selectWhere() {
        return this.newCriteriaSupport().wrapIntoExecutable();
    }

    @Override
    public EntityQueryCriteriaSupport<C, I> newCriteriaSupport() {
        return new EntityQueryCriteriaSupport<C, I>(this.criteriaSupport, this.entitySelector, this.getPersisterListener());
    }

    public EntityPersister.ExecutableProjectionQuery<C, ?> selectProjectionWhere(Consumer<Select> selectAdapter) {
        ProjectionQueryCriteriaSupport<C, I> projectionSupport = new ProjectionQueryCriteriaSupport<C, I>(this.criteriaSupport, this.entitySelector, selectAdapter);
        return projectionSupport.wrapIntoExecutable();
    }

    public Set<C> selectAll() {
        return (Set)this.selectWhere().execute(Accumulators.toSet());
    }

    public boolean isNew(C entity) {
        return this.mainPersister.isNew(entity);
    }

    public Class<C> getClassToPersist() {
        return this.mainPersister.getClassToPersist();
    }

    @Override
    public EntityJoinTree<C, I> getEntityJoinTree() {
        return this.mainPersister.getEntityJoinTree();
    }
}

