/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.polymorphism;

import java.util.Map;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ValueAccessPointMap;
import org.codefilarete.stalactite.engine.PersisterRegistry;
import org.codefilarete.stalactite.engine.PolymorphismPolicy;
import org.codefilarete.stalactite.engine.configurer.AbstractIdentification;
import org.codefilarete.stalactite.engine.configurer.NamingConfiguration;
import org.codefilarete.stalactite.engine.configurer.polymorphism.AbstractPolymorphicPersisterBuilder;
import org.codefilarete.stalactite.engine.configurer.polymorphism.JoinTablePolymorphismBuilder;
import org.codefilarete.stalactite.engine.configurer.polymorphism.PolymorphismBuilder;
import org.codefilarete.stalactite.engine.configurer.polymorphism.SingleTablePolymorphismBuilder;
import org.codefilarete.stalactite.engine.configurer.polymorphism.TablePerClassPolymorphismBuilder;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.PersisterListenerWrapper;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.tool.exception.NotImplementedException;
import org.codefilarete.tool.function.Converter;

public class PolymorphismPersisterBuilder<C, I, T extends Table>
implements PolymorphismBuilder<C, I, T> {
    private final PolymorphismPolicy<C> polymorphismPolicy;
    private final ConfiguredRelationalPersister<C, I> mainPersister;
    private final AbstractIdentification<C, I> identification;
    private final ColumnBinderRegistry columnBinderRegistry;
    private final Map<ReversibleAccessor<C, Object>, Column<T, Object>> mainMapping;
    private final Map<ReversibleAccessor<C, Object>, Column<T, Object>> mainReadonlyMapping;
    private final ValueAccessPointMap<C, Converter<Object, Object>> mainReadConverters;
    private final ValueAccessPointMap<C, Converter<Object, Object>> mainWriteConverters;
    private final NamingConfiguration namingConfiguration;

    public PolymorphismPersisterBuilder(PolymorphismPolicy<C> polymorphismPolicy, AbstractIdentification<C, I> identification, ConfiguredRelationalPersister<C, I> mainPersister, ColumnBinderRegistry columnBinderRegistry, Map<? extends ReversibleAccessor<C, Object>, Column<T, Object>> mainMapping, Map<? extends ReversibleAccessor<C, Object>, Column<T, Object>> mainReadonlyMapping, ValueAccessPointMap<C, ? extends Converter<Object, Object>> mainReadConverters, ValueAccessPointMap<C, ? extends Converter<Object, Object>> mainWriteConverters, NamingConfiguration namingConfiguration) {
        this.polymorphismPolicy = polymorphismPolicy;
        this.identification = identification;
        this.mainPersister = mainPersister;
        this.columnBinderRegistry = columnBinderRegistry;
        this.mainMapping = mainMapping;
        this.mainReadonlyMapping = mainReadonlyMapping;
        this.mainReadConverters = mainReadConverters;
        this.mainWriteConverters = mainWriteConverters;
        this.namingConfiguration = namingConfiguration;
    }

    @Override
    public ConfiguredRelationalPersister<C, I> build(Dialect dialect, ConnectionConfiguration connectionConfiguration, PersisterRegistry persisterRegistry) {
        AbstractPolymorphicPersisterBuilder polymorphismBuilder;
        if (this.polymorphismPolicy instanceof PolymorphismPolicy.SingleTablePolymorphism) {
            polymorphismBuilder = new SingleTablePolymorphismBuilder((PolymorphismPolicy.SingleTablePolymorphism)this.polymorphismPolicy, this.identification, this.mainPersister, this.mainMapping, this.mainReadonlyMapping, this.mainReadConverters, this.mainWriteConverters, this.columnBinderRegistry, this.namingConfiguration);
        } else if (this.polymorphismPolicy instanceof PolymorphismPolicy.TablePerClassPolymorphism) {
            polymorphismBuilder = new TablePerClassPolymorphismBuilder<C, I, T>((PolymorphismPolicy.TablePerClassPolymorphism)this.polymorphismPolicy, this.identification, this.mainPersister, this.mainMapping, this.mainReadonlyMapping, this.mainReadConverters, this.mainWriteConverters, this.columnBinderRegistry, this.namingConfiguration);
        } else if (this.polymorphismPolicy instanceof PolymorphismPolicy.JoinTablePolymorphism) {
            polymorphismBuilder = new JoinTablePolymorphismBuilder((PolymorphismPolicy.JoinTablePolymorphism)this.polymorphismPolicy, this.identification, this.mainPersister, this.columnBinderRegistry, this.namingConfiguration);
        } else {
            throw new NotImplementedException("Given policy is not implemented : " + this.polymorphismPolicy);
        }
        ConfiguredRelationalPersister result = polymorphismBuilder.build(dialect, connectionConfiguration, persisterRegistry);
        result = new PersisterListenerWrapper(result);
        this.mainPersister.getPersisterListener().moveTo(result.getPersisterListener());
        return result;
    }
}

