/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codefilarete.stalactite.query.model.AbstractCriterion;
import org.codefilarete.stalactite.query.model.ColumnCriterion;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.CriteriaChain;
import org.codefilarete.stalactite.query.model.RawCriterion;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.tool.collection.Iterables;

public class Criteria<SELF extends Criteria<SELF>>
extends AbstractCriterion
implements CriteriaChain<SELF> {
    protected List<AbstractCriterion> conditions = new ArrayList<AbstractCriterion>();

    public Criteria() {
    }

    public Criteria(Column column, String condition) {
        this.add(new ColumnCriterion(column, condition));
    }

    public Criteria(Column column, ConditionalOperator condition) {
        this.add(new ColumnCriterion(column, condition));
    }

    public Criteria(Object ... columns) {
        this.add(new RawCriterion(columns));
    }

    protected void setOperator(AbstractCriterion.LogicalOperator operator) {
        this.operator = operator;
    }

    public List<AbstractCriterion> getConditions() {
        return this.conditions;
    }

    public SELF add(AbstractCriterion condition) {
        this.conditions.add(condition);
        return (SELF)this;
    }

    @Override
    public SELF and(Column column, CharSequence condition) {
        return this.add(new ColumnCriterion(AbstractCriterion.LogicalOperator.AND, column, condition));
    }

    @Override
    public SELF and(Column column, ConditionalOperator condition) {
        return this.add(new ColumnCriterion(AbstractCriterion.LogicalOperator.AND, column, condition));
    }

    @Override
    public SELF or(Column column, CharSequence condition) {
        return this.add(new ColumnCriterion(AbstractCriterion.LogicalOperator.OR, column, condition));
    }

    @Override
    public SELF or(Column column, ConditionalOperator condition) {
        return this.add(new ColumnCriterion(AbstractCriterion.LogicalOperator.OR, column, condition));
    }

    @Override
    public SELF and(Criteria criteria) {
        criteria.setOperator(AbstractCriterion.LogicalOperator.AND);
        return this.add(criteria);
    }

    @Override
    public SELF or(Criteria criteria) {
        criteria.setOperator(AbstractCriterion.LogicalOperator.OR);
        return this.add(criteria);
    }

    @Override
    public SELF and(Object ... columns) {
        return this.add(new RawCriterion(AbstractCriterion.LogicalOperator.AND, columns));
    }

    @Override
    public SELF or(Object ... columns) {
        return this.add(new RawCriterion(AbstractCriterion.LogicalOperator.OR, columns));
    }

    public Object remove(int index) {
        return this.conditions.remove(index);
    }

    public List<AbstractCriterion> clear() {
        List result = Iterables.copy(this.conditions);
        this.conditions.clear();
        return result;
    }

    @Override
    public Iterator<AbstractCriterion> iterator() {
        return this.conditions.iterator();
    }
}

