/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.statement.SQLExecutionException;
import org.codefilarete.stalactite.sql.statement.SQLOperation;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.tool.exception.Exceptions;
import org.codefilarete.tool.function.ThrowingExecutable;

public class WriteOperation<ParamType>
extends SQLOperation<ParamType> {
    private int batchedStatementCount = 0;
    private final Map<Integer, Map<ParamType, ?>> batchedValues = new HashMap();
    private final RowCountListener rowCountListener;

    public WriteOperation(SQLStatement<ParamType> sqlGenerator, ConnectionProvider connectionProvider, RowCountListener rowCountListener) {
        super(sqlGenerator, connectionProvider);
        this.rowCountListener = rowCountListener;
    }

    public void execute() {
        long writeCount;
        this.prepareExecute();
        try {
            writeCount = this.doExecuteUpdate();
        }
        catch (SQLException e) {
            throw new SQLExecutionException(this.getSQL(), e);
        }
        this.rowCountListener.onRowCount(writeCount);
    }

    public void executeBatch() {
        long[] updatedRowCounts;
        LOGGER.debug("Batching statement {} times", (Object)this.batchedStatementCount);
        try {
            this.getListener().onExecute(this.getSqlStatement());
            updatedRowCounts = (long[])this.doWithLogManagement(this::doExecuteBatch);
        }
        finally {
            this.batchedStatementCount = 0;
        }
        this.rowCountListener.onRowCounts(updatedRowCounts);
    }

    protected long[] doExecuteBatch() throws SQLException {
        return this.preparedStatement.executeLargeBatch();
    }

    protected long doExecuteUpdate() throws SQLException {
        return this.preparedStatement.executeLargeUpdate();
    }

    private <T, E extends SQLException> T doWithLogManagement(ThrowingExecutable<T, E> delegateWithResult) {
        this.logExecution(() -> {
            HashMap valuesClone = new HashMap(this.batchedValues);
            valuesClone.entrySet().forEach(e -> e.setValue(this.filterLoggable((Map)e.getValue())));
            return valuesClone.toString();
        });
        try {
            Object object = delegateWithResult.execute();
            return (T)object;
        }
        catch (SQLException e) {
            throw new SQLExecutionException(this.getSQL(), e);
        }
        finally {
            if (LOGGER.isTraceEnabled()) {
                this.batchedValues.clear();
            }
        }
    }

    public void addBatch(Map<ParamType, ?> values) {
        this.setValues(values);
        this.applyValuesToEnsuredStatement();
        ++this.batchedStatementCount;
        if (LOGGER.isTraceEnabled()) {
            this.batchedValues.put(this.batchedStatementCount, values);
        }
        try {
            this.preparedStatement.addBatch();
        }
        catch (SQLException e) {
            throw Exceptions.asRuntimeException((Throwable)e);
        }
    }

    public static interface RowCountListener {
        default public void onRowCounts(long[] writeCounts) {
            for (long writeCount : writeCounts) {
                this.onRowCount(writeCount);
            }
        }

        public void onRowCount(long var1);
    }
}

