/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.spring.repository.query;

import java.util.Collection;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorByMember;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.runtime.AdvancedEntityPersister;
import org.codefilarete.stalactite.engine.runtime.EntityQueryCriteriaSupport;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.stalactite.sql.spring.repository.query.AbstractDerivedQuery;
import org.codefilarete.tool.Nullable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

public class PartTreeStalactiteQuery<C, R>
implements RepositoryQuery {
    protected final QueryMethod method;
    protected final DerivedQuery<C> query;
    protected final Accumulator<C, Collection<C>, R> accumulator;

    public PartTreeStalactiteQuery(QueryMethod method, AdvancedEntityPersister<C, ?> entityPersister, PartTree tree, Accumulator<C, ? extends Collection<C>, R> accumulator) {
        this.method = method;
        this.accumulator = accumulator;
        Parameters parameters = method.getParameters();
        try {
            this.query = new DerivedQuery(entityPersister, tree);
            if (tree.getSort().isSorted()) {
                tree.getSort().iterator().forEachRemaining(order -> {
                    PropertyPath propertyPath = PropertyPath.from((String)order.getProperty(), (Class)entityPersister.getClassToPersist());
                    AccessorChain orderProperty = this.query.convertToAccessorChain(propertyPath);
                    this.query.executableEntityQuery.getQueryPageSupport().orderBy(orderProperty, order.getDirection() == Sort.Direction.ASC ? EntityPersister.OrderByChain.Order.ASC : EntityPersister.OrderByChain.Order.DESC);
                });
            }
            Nullable.nullable((Object)tree.getMaxResults()).invoke(arg_0 -> ((EntityQueryCriteriaSupport.EntityQueryPageSupport)this.query.executableEntityQuery.getQueryPageSupport()).limit(arg_0));
        }
        catch (RuntimeException o_O) {
            throw new IllegalArgumentException(String.format("Failed to create query for method %s! %s", method, o_O.getMessage()), o_O);
        }
    }

    @org.springframework.lang.Nullable
    public R execute(Object[] parameters) {
        this.query.criteriaChain.consume(parameters);
        EntityQueryCriteriaSupport<C, ?> derivedQueryToUse = this.handleDynamicSort(parameters);
        Object result = derivedQueryToUse.wrapGraphLoad().apply(this.accumulator);
        if (this.method.getResultProcessor().getReturnedType().isProjecting() || this.method.getParameters().hasDynamicProjection()) {
            ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.method.getParameters(), parameters);
            return (R)this.method.getResultProcessor().withDynamicProjection((ParameterAccessor)accessor).processResult(result);
        }
        return result;
    }

    private EntityQueryCriteriaSupport<C, ?> handleDynamicSort(Object[] parameters) {
        EntityQueryCriteriaSupport derivedQueryToUse;
        ParametersParameterAccessor parameterHelper = new ParametersParameterAccessor(this.getQueryMethod().getParameters(), parameters);
        if (parameterHelper.getSort().isSorted()) {
            DerivedQuery derivedQuery = new DerivedQuery(this.query.executableEntityQuery);
            Class declaringClass = this.getQueryMethod().getEntityInformation().getJavaType();
            parameterHelper.getSort().stream().forEachOrdered(order -> {
                AccessorByMember accessor = Accessors.accessor((Class)declaringClass, (String)order.getProperty());
                derivedQuery.dynamicSortSupport.orderBy(new AccessorChain(new Accessor[]{accessor}), order.getDirection() == Sort.Direction.ASC ? EntityPersister.OrderByChain.Order.ASC : EntityPersister.OrderByChain.Order.DESC);
            });
            derivedQueryToUse = derivedQuery.executableEntityQuery.copyFor(derivedQuery.dynamicSortSupport);
        } else {
            derivedQueryToUse = this.query.executableEntityQuery;
        }
        return derivedQueryToUse;
    }

    public QueryMethod getQueryMethod() {
        return this.method;
    }

    static class DerivedQuery<T>
    extends AbstractDerivedQuery<T> {
        protected final EntityQueryCriteriaSupport<T, ?> executableEntityQuery;
        protected final EntityQueryCriteriaSupport.EntityQueryPageSupport<T> dynamicSortSupport = new EntityQueryCriteriaSupport.EntityQueryPageSupport();

        private DerivedQuery(AdvancedEntityPersister<T, ?> entityPersister, PartTree tree) {
            this.executableEntityQuery = entityPersister.newCriteriaSupport();
            tree.forEach(orPart -> orPart.forEach(this::append));
        }

        private DerivedQuery(EntityQueryCriteriaSupport<T, ?> executableEntityQuery) {
            this.executableEntityQuery = executableEntityQuery;
        }

        private void append(Part part) {
            AbstractDerivedQuery.Criterion criterion = this.convertToCriterion(part.getType());
            this.executableEntityQuery.getEntityCriteriaSupport().and(this.convertToAccessorChain(part.getProperty()), criterion.operator);
            this.criteriaChain.criteria.add(criterion);
        }
    }
}

