/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.stream.LongStream;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.SQLiteDMLGenerator;
import org.codefilarete.stalactite.sql.SQLiteGeneratedKeysReader;
import org.codefilarete.stalactite.sql.ddl.DDLTableGenerator;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.ddl.SQLiteDDLTableGenerator;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.statement.DMLGenerator;
import org.codefilarete.stalactite.sql.statement.GeneratedKeysReader;
import org.codefilarete.stalactite.sql.statement.ReadOperationFactory;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.WriteOperation;
import org.codefilarete.stalactite.sql.statement.WriteOperationFactory;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinderIndex;
import org.codefilarete.stalactite.sql.statement.binder.SQLiteTypeMapping;
import org.codefilarete.tool.function.ThrowingBiFunction;

public class SQLiteDialect
extends Dialect {
    public SQLiteDialect() {
        super((JavaTypeToSqlTypeMapping)new SQLiteTypeMapping());
    }

    public <I> GeneratedKeysReader<I> buildGeneratedKeysReader(String keyName, Class<I> columnType) {
        return new SQLiteGeneratedKeysReader();
    }

    protected DMLGenerator newDmlGenerator(ColumnBinderRegistry columnBinderRegistry) {
        return new SQLiteDMLGenerator((ParameterBinderIndex<Column, ParameterBinder>)columnBinderRegistry);
    }

    protected DDLTableGenerator newDdlTableGenerator() {
        return new SQLiteDDLTableGenerator(this.getSqlTypeRegistry());
    }

    protected ReadOperationFactory newReadOperationFactory() {
        return new SQLiteReadOperationFactory();
    }

    protected WriteOperationFactory newWriteOperationFactory() {
        return new SQLiteWriteOperationFactory();
    }

    static class SQLiteWriteOperation<ParamType>
    extends WriteOperation<ParamType> {
        private long updatedRowCount = 0L;

        public SQLiteWriteOperation(SQLStatement<ParamType> sqlGenerator, ConnectionProvider connectionProvider, WriteOperation.RowCountListener rowCountListener) {
            super(sqlGenerator, connectionProvider, rowCountListener);
        }

        public long getUpdatedRowCount() {
            return this.updatedRowCount;
        }

        protected long[] doExecuteBatch() throws SQLException {
            long[] rowCounts = super.doExecuteBatch();
            this.updatedRowCount = LongStream.of(rowCounts).sum();
            return rowCounts;
        }
    }

    public static class SQLiteWriteOperationFactory
    extends WriteOperationFactory {
        protected <ParamType> WriteOperation<ParamType> createInstance(SQLStatement<ParamType> sqlGenerator, ConnectionProvider connectionProvider, final ThrowingBiFunction<Connection, String, PreparedStatement, SQLException> statementProvider, WriteOperation.RowCountListener rowCountListener) {
            return new SQLiteWriteOperation<ParamType>(sqlGenerator, connectionProvider, rowCountListener){

                protected void prepareStatement(Connection connection) throws SQLException {
                    this.preparedStatement = (PreparedStatement)statementProvider.apply((Object)connection, (Object)this.getSQL());
                }
            };
        }
    }

    public static class SQLiteReadOperationFactory
    extends ReadOperationFactory {
    }
}

