/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.engine.CascadeOptions;
import org.codefilarete.stalactite.engine.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.FluentEntityMappingBuilder;
import org.codefilarete.stalactite.engine.ForeignKeyNamingStrategy;
import org.codefilarete.stalactite.engine.JdbcForeignKey;
import org.codefilarete.stalactite.engine.MappingEase;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.idprovider.LongProvider;
import org.codefilarete.stalactite.engine.model.City;
import org.codefilarete.stalactite.engine.model.Country;
import org.codefilarete.stalactite.engine.model.Person;
import org.codefilarete.stalactite.engine.model.State;
import org.codefilarete.stalactite.engine.runtime.ConfiguredPersister;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.id.PersistableIdentifier;
import org.codefilarete.stalactite.id.PersistedIdentifier;
import org.codefilarete.stalactite.id.StatefulIdentifierAlreadyAssignedIdentifierPolicy;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.HSQLDBDialect;
import org.codefilarete.stalactite.sql.ddl.DDLDeployer;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.result.ResultSetIterator;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.sql.test.HSQLDBInMemoryDataSource;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FluentEntityMappingConfigurationSupportToOneAndToManyMixTest {
    private final HSQLDBDialect dialect = new HSQLDBDialect();
    private final DataSource dataSource = new HSQLDBInMemoryDataSource();
    private PersistenceContext persistenceContext;
    private FluentEntityMappingBuilder<City, Identifier<Long>> cityMappingConfiguration;
    private FluentEntityMappingBuilder<Person, Identifier<Long>> personMappingConfiguration;

    @BeforeEach
    public void initTest() {
        FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions cityMappingBuilder;
        FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions personMappingBuilder;
        this.dialect.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        this.dialect.getSqlTypeRegistry().put(Identifier.class, "int");
        this.persistenceContext = new PersistenceContext(this.dataSource, (Dialect)this.dialect);
        this.personMappingConfiguration = personMappingBuilder = MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName);
        this.cityMappingConfiguration = cityMappingBuilder = MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName);
    }

    @Test
    void foreignKeyIsCreated() throws SQLException {
        ConfiguredPersister countryPersister = (ConfiguredPersister)MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).withForeignKeyNaming(ForeignKeyNamingStrategy.DEFAULT).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToOne(Country::getPresident, this.personMappingConfiguration).mapOneToMany(Country::getCities, this.cityMappingConfiguration).mappedBy(City::setCountry).cascading(CascadeOptions.RelationMode.READ_ONLY).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Connection currentConnection = this.persistenceContext.getConnectionProvider().giveConnection();
        ResultSetIterator<JdbcForeignKey> fkPersonIterator = new ResultSetIterator<JdbcForeignKey>(currentConnection.getMetaData().getExportedKeys(null, null, ((ConfiguredPersister)this.persistenceContext.getPersister(Person.class)).getMapping().getTargetTable().getName().toUpperCase())){

            public JdbcForeignKey convert(ResultSet rs) throws SQLException {
                return new JdbcForeignKey(rs.getString("FK_NAME"), rs.getString("FKTABLE_NAME"), rs.getString("FKCOLUMN_NAME"), rs.getString("PKTABLE_NAME"), rs.getString("PKCOLUMN_NAME"));
            }
        };
        JdbcForeignKey foundForeignKey = (JdbcForeignKey)Iterables.first((Iterator)fkPersonIterator);
        JdbcForeignKey expectedForeignKey = new JdbcForeignKey("FK_COUNTRY_PRESIDENTID_PERSON_ID", "COUNTRY", "PRESIDENTID", "PERSON", "ID");
        Assertions.assertThat((String)foundForeignKey.getSignature()).isEqualTo(expectedForeignKey.getSignature());
        ResultSetIterator<JdbcForeignKey> fkCityIterator = new ResultSetIterator<JdbcForeignKey>(currentConnection.getMetaData().getExportedKeys(null, null, countryPersister.getMapping().getTargetTable().getName().toUpperCase())){

            public JdbcForeignKey convert(ResultSet rs) throws SQLException {
                return new JdbcForeignKey(rs.getString("FK_NAME"), rs.getString("FKTABLE_NAME"), rs.getString("FKCOLUMN_NAME"), rs.getString("PKTABLE_NAME"), rs.getString("PKCOLUMN_NAME"));
            }
        };
        foundForeignKey = (JdbcForeignKey)Iterables.first((Iterator)fkCityIterator);
        expectedForeignKey = new JdbcForeignKey("FK_CITY_COUNTRYID_COUNTRY_ID", "CITY", "COUNTRYID", "COUNTRY", "ID");
        Assertions.assertThat((String)foundForeignKey.getSignature()).isEqualTo(expectedForeignKey.getSignature());
    }

    @Test
    public void testCascade_oneToOneAndOneToMany_CRUD() {
        EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).mapOneToOne(Country::getPresident, this.personMappingConfiguration).cascading(CascadeOptions.RelationMode.ALL).mapOneToMany(Country::getCities, this.cityMappingConfiguration).cascading(CascadeOptions.RelationMode.ALL).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        LongProvider countryIdProvider = new LongProvider();
        Country dummyCountry = new Country((Long)countryIdProvider.giveNewIdentifier());
        dummyCountry.setName("France");
        Person person = new Person((Long)new LongProvider().giveNewIdentifier());
        person.setName("French president");
        dummyCountry.setPresident(person);
        LongProvider cityIdentifierProvider = new LongProvider();
        City capital = new City((Long)cityIdentifierProvider.giveNewIdentifier());
        capital.setName("Paris");
        dummyCountry.addCity(capital);
        countryPersister.insert((Object)dummyCountry);
        Country persistedCountry = (Country)countryPersister.select(dummyCountry.getId());
        Assertions.assertThat(persistedCountry.getId()).isEqualTo(new PersistedIdentifier<Long>(0L));
        Assertions.assertThat((String)persistedCountry.getPresident().getName()).isEqualTo("French president");
        Assertions.assertThat((String)((City)Iterables.first(persistedCountry.getCities())).getName()).isEqualTo("Paris");
        Assertions.assertThat((boolean)persistedCountry.getPresident().getId().isPersisted()).isTrue();
        Assertions.assertThat((boolean)((City)Iterables.first(persistedCountry.getCities())).getId().isPersisted()).isTrue();
        persistedCountry.getPresident().setName("New french president");
        City grenoble = new City((Long)cityIdentifierProvider.giveNewIdentifier());
        grenoble.setName("Grenoble");
        persistedCountry.addCity(grenoble);
        countryPersister.update((Object)persistedCountry, (Object)dummyCountry, true);
        persistedCountry = (Country)countryPersister.select(dummyCountry.getId());
        Assertions.assertThat(persistedCountry.getId()).isEqualTo(new PersistedIdentifier<Long>(0L));
        Assertions.assertThat((String)persistedCountry.getPresident().getName()).isEqualTo("New french president");
        Assertions.assertThat(persistedCountry.getCities()).extracting(City::getName).containsExactlyInAnyOrder((Object[])new String[]{"Grenoble", "Paris"});
        Assertions.assertThat((boolean)persistedCountry.getPresident().getId().isPersisted()).isTrue();
        Assertions.assertThat((boolean)((City)Iterables.first(persistedCountry.getCities())).getId().isPersisted()).isTrue();
    }

    @Test
    public void testCascade_SetSetMix_update() {
        FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions stateMappingBuilder = MappingEase.entityBuilder(State.class, Identifier.LONG_TYPE).mapKey(State::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(State::getName);
        EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToMany(Country::getCities, this.cityMappingConfiguration).mappedBy(City::setCountry).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).mapOneToMany(Country::getStates, (EntityMappingConfigurationProvider)stateMappingBuilder).mappedBy(State::setCountry).cascading(CascadeOptions.RelationMode.ALL).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        LongProvider countryIdProvider = new LongProvider();
        Country dummyCountry = new Country((Long)countryIdProvider.giveNewIdentifier());
        dummyCountry.setName("France");
        dummyCountry.setDescription("Smelly cheese !");
        LongProvider cityIdProvider = new LongProvider();
        City paris = new City((Long)cityIdProvider.giveNewIdentifier());
        paris.setName("Paris");
        dummyCountry.addCity(paris);
        City lyon = new City((Long)cityIdProvider.giveNewIdentifier());
        lyon.setName("Lyon");
        dummyCountry.addCity(lyon);
        LongProvider stateIdProvider = new LongProvider();
        State isere = new State(new PersistableIdentifier<Object>(stateIdProvider.giveNewIdentifier()));
        isere.setName("Isere");
        dummyCountry.addState(isere);
        State ain = new State(new PersistableIdentifier<Object>(stateIdProvider.giveNewIdentifier()));
        ain.setName("ain");
        dummyCountry.addState(ain);
        countryPersister.insert((Object)dummyCountry);
        Country persistedCountry = (Country)countryPersister.select(dummyCountry.getId());
        persistedCountry.getCities().remove(paris);
        City grenoble = new City((Long)cityIdProvider.giveNewIdentifier());
        grenoble.setName("Grenoble");
        persistedCountry.addCity(grenoble);
        ((City)Iterables.first(persistedCountry.getCities())).setName("changed");
        persistedCountry.getStates().remove(ain);
        State ardeche = new State(new PersistableIdentifier<Object>(cityIdProvider.giveNewIdentifier()));
        ardeche.setName("ardeche");
        persistedCountry.addState(ardeche);
        ((State)Iterables.first(persistedCountry.getStates())).setName("changed");
        countryPersister.update((Object)persistedCountry, (Object)dummyCountry, true);
        Country persistedCountry2 = (Country)countryPersister.select(dummyCountry.getId());
        Assertions.assertThat(persistedCountry2.getCities()).isEqualTo((Object)Arrays.asHashSet((Object[])new City[]{lyon, grenoble}));
        Assertions.assertThat(persistedCountry2.getStates()).isEqualTo((Object)Arrays.asHashSet((Object[])new State[]{ardeche, isere}));
        Assertions.assertThat((Collection)persistedCountry2.getCities().stream().map(City::getName).collect(Collectors.toSet())).isEqualTo((Object)Arrays.asHashSet((Object[])new String[]{"changed", "Grenoble"}));
        Assertions.assertThat((Collection)persistedCountry2.getStates().stream().map(State::getName).collect(Collectors.toSet())).isEqualTo((Object)Arrays.asHashSet((Object[])new String[]{"changed", "ardeche"}));
        PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = this.persistenceContext.newQuery((CharSequence)("select id from State where id = " + ain.getId().getSurrogate()), Long.class).mapKey(Long::new, "id", Long.TYPE);
        Set loadedAin = (Set)longExecutableQuery.execute(Accumulators.toSet());
        Assertions.assertThat((Long)((Long)Iterables.first((Iterable)loadedAin))).isNotNull();
    }

    @Test
    public void testCascade_ListSetMix_listContainsDuplicate_CRUD() {
        FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions stateMappingBuilder = MappingEase.entityBuilder(State.class, Identifier.LONG_TYPE).mapKey(State::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(State::getName);
        EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToMany(Country::getAncientCities, this.cityMappingConfiguration).reverselySetBy(City::setCountry).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).indexed().mapOneToMany(Country::getStates, (EntityMappingConfigurationProvider)stateMappingBuilder).mappedBy(State::setCountry).cascading(CascadeOptions.RelationMode.ALL).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        LongProvider countryIdProvider = new LongProvider();
        Country dummyCountry = new Country((Long)countryIdProvider.giveNewIdentifier());
        dummyCountry.setName("France");
        dummyCountry.setDescription("Smelly cheese !");
        LongProvider cityIdProvider = new LongProvider();
        City paris = new City((Long)cityIdProvider.giveNewIdentifier());
        paris.setName("Paris");
        dummyCountry.addAncientCity(paris);
        City lyon = new City((Long)cityIdProvider.giveNewIdentifier());
        lyon.setName("Lyon");
        dummyCountry.addAncientCity(lyon);
        dummyCountry.addAncientCity(lyon);
        LongProvider stateIdProvider = new LongProvider();
        State isere = new State(new PersistableIdentifier<Object>(stateIdProvider.giveNewIdentifier()));
        isere.setName("Isere");
        dummyCountry.addState(isere);
        State ain = new State(new PersistableIdentifier<Object>(stateIdProvider.giveNewIdentifier()));
        ain.setName("ain");
        dummyCountry.addState(ain);
        countryPersister.insert((Object)dummyCountry);
        Country persistedCountry = (Country)countryPersister.select(dummyCountry.getId());
        Assertions.assertThat((Object)persistedCountry).isEqualTo((Object)dummyCountry);
        persistedCountry.getAncientCities().remove(paris);
        City grenoble = new City((Long)cityIdProvider.giveNewIdentifier());
        grenoble.setName("Grenoble");
        persistedCountry.addAncientCity(grenoble);
        ((City)Iterables.first(persistedCountry.getAncientCities())).setName("changed");
        persistedCountry.getStates().remove(ain);
        State ardeche = new State(new PersistableIdentifier<Object>(cityIdProvider.giveNewIdentifier()));
        ardeche.setName("ardeche");
        persistedCountry.addState(ardeche);
        ((State)Iterables.first(persistedCountry.getStates())).setName("changed");
        countryPersister.update((Object)persistedCountry, (Object)dummyCountry, true);
        Country persistedCountry2 = (Country)countryPersister.select(dummyCountry.getId());
        Assertions.assertThat(persistedCountry2.getAncientCities()).isEqualTo((Object)Arrays.asList((Object[])new City[]{lyon, lyon, grenoble}));
        Assertions.assertThat(persistedCountry2.getStates()).isEqualTo((Object)Arrays.asHashSet((Object[])new State[]{ardeche, isere}));
        Assertions.assertThat((Collection)persistedCountry2.getAncientCities().stream().map(City::getName).collect(Collectors.toSet())).isEqualTo((Object)Arrays.asHashSet((Object[])new String[]{"changed", "Grenoble"}));
        Assertions.assertThat((Collection)persistedCountry2.getStates().stream().map(State::getName).collect(Collectors.toSet())).isEqualTo((Object)Arrays.asHashSet((Object[])new String[]{"changed", "ardeche"}));
        PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = this.persistenceContext.newQuery((CharSequence)("select id from State where id = " + ain.getId().getSurrogate()), Long.class).mapKey(Long::new, "id", Long.TYPE);
        Set loadedAin = (Set)longExecutableQuery.execute(Accumulators.toSet());
        Assertions.assertThat((Long)((Long)Iterables.first((Iterable)loadedAin))).isNotNull();
    }
}

