/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.test;

import com.mysql.cj.jdbc.MysqlDataSource;
import java.sql.SQLException;
import java.util.EnumMap;
import java.util.Map;
import javax.sql.DataSource;
import org.codefilarete.stalactite.sql.UrlAwareDataSource;
import org.codefilarete.tool.bean.Objects;
import org.codefilarete.tool.exception.Exceptions;

public class MySQLDataSource
extends UrlAwareDataSource {
    private static final EnumMap<Property, Object> DEFAULT_PROPERTIES = new EnumMap(Property.class);

    private MySQLDataSource(String url, DataSource delegate) {
        super(url, delegate);
    }

    public MySQLDataSource(String schema, String user, String password) {
        this("localhost", schema, user, password, DEFAULT_PROPERTIES);
    }

    public MySQLDataSource(String host, String schema, String user, String password) {
        this(host, schema, user, password, DEFAULT_PROPERTIES);
    }

    public MySQLDataSource(String host, String schema, String user, String password, EnumMap<Property, Object> properties) {
        this("jdbc:mysql://" + host + "/" + schema, null);
        try {
            MysqlDataSource mysqlDataSource = new MysqlDataSource();
            mysqlDataSource.setUrl(this.getUrl());
            mysqlDataSource.setUser(user);
            mysqlDataSource.setPassword(password);
            EnumMap<Property, Object> propertiesToApply = new EnumMap<Property, Object>(DEFAULT_PROPERTIES);
            propertiesToApply.putAll(properties);
            this.applyProperties(mysqlDataSource, propertiesToApply);
            this.setDelegate((DataSource)mysqlDataSource);
        }
        catch (SQLException e) {
            throw Exceptions.asRuntimeException((Throwable)e);
        }
    }

    private void applyProperties(MysqlDataSource mysqlDataSource, EnumMap<Property, Object> properties) throws SQLException {
        for (Map.Entry<Property, Object> entry : properties.entrySet()) {
            switch (entry.getKey()) {
                case rewriteBatchedStatements: {
                    mysqlDataSource.setRewriteBatchedStatements(((Boolean)Objects.preventNull((Object)((Boolean)entry.getValue()), (Object)true)).booleanValue());
                    break;
                }
                case cachePreparedStatements: {
                    mysqlDataSource.setCachePrepStmts(((Boolean)Objects.preventNull((Object)((Boolean)entry.getValue()), (Object)true)).booleanValue());
                    break;
                }
                case preparedStatementCacheSize: {
                    mysqlDataSource.setPrepStmtCacheSize(((Integer)Objects.preventNull((Object)((Integer)entry.getValue()), (Object)100)).intValue());
                    break;
                }
                case preparedStatementCacheSqlLimit: {
                    mysqlDataSource.setPrepStmtCacheSqlLimit(((Integer)Objects.preventNull((Object)((Integer)entry.getValue()), (Object)2048)).intValue());
                }
            }
        }
    }

    static {
        DEFAULT_PROPERTIES.put(Property.rewriteBatchedStatements, (Object)true);
        DEFAULT_PROPERTIES.put(Property.cachePreparedStatements, (Object)true);
        DEFAULT_PROPERTIES.put(Property.preparedStatementCacheSize, (Object)100);
        DEFAULT_PROPERTIES.put(Property.preparedStatementCacheSqlLimit, (Object)2048);
    }

    public static enum Property {
        rewriteBatchedStatements,
        cachePreparedStatements,
        preparedStatementCacheSize,
        preparedStatementCacheSqlLimit;

    }
}

