/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.map;

import java.util.Collections;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.lang3.builder.MultilineRecursiveToStringStyle;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.presentation.Representation;
import org.assertj.core.presentation.StandardRepresentation;
import org.codefilarete.stalactite.engine.configurer.map.KeyValueRecordMapping;
import org.codefilarete.stalactite.engine.configurer.map.RecordId;
import org.codefilarete.stalactite.mapping.ColumnedRow;
import org.codefilarete.stalactite.mapping.id.assembly.ComposedIdentifierAssembler;
import org.codefilarete.stalactite.mapping.id.assembly.IdentifierAssembler;
import org.codefilarete.stalactite.mapping.id.assembly.SimpleIdentifierAssembler;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Row;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class KeyValueRecordMappingTest {
    KeyValueRecordMappingTest() {
    }

    private static class EntryKey {
        private final long prop1;
        private final String prop2;

        public EntryKey(long prop1, String prop2) {
            this.prop1 = prop1;
            this.prop2 = prop2;
        }
    }

    @Nested
    class RecordIdAssemblerTest {
        RecordIdAssemblerTest() {
        }

        @Test
        <T extends Table<T>, LEFTTABLE extends Table<LEFTTABLE>, RIGHTTABLE extends Table<RIGHTTABLE>> void assemble_mapEntryKeyIsASimpleProperty_recordIdContainsIdentifiers() {
            Table joinTable = new Table("joinTable");
            Column joinTableIdColumn = joinTable.addColumn("id", Long.TYPE);
            Column entryKeyColumn = joinTable.addColumn("entryKey", String.class);
            Table leftTable = new Table("leftTable");
            Column leftTableIdColumn = leftTable.addColumn("id", Long.TYPE);
            BiFunction<Row, ColumnedRow, String> entryKeyAssembler = (row, columnedRow) -> (String)columnedRow.getValue((Selectable)entryKeyColumn, row);
            SimpleIdentifierAssembler sourceIdentifierAssembler = new SimpleIdentifierAssembler(leftTableIdColumn);
            Map primaryKey2ForeignKeyMapping = Collections.emptyMap();
            KeyValueRecordMapping.KeyValueRecordIdMapping.RecordIdAssembler testInstance = new KeyValueRecordMapping.KeyValueRecordIdMapping.RecordIdAssembler(joinTable, entryKeyAssembler, s -> {
                throw new RuntimeException("This code should be called since its used in getColumnValues()");
            }, (IdentifierAssembler)sourceIdentifierAssembler, primaryKey2ForeignKeyMapping);
            Row row2 = new Row();
            row2.add("id", (Object)42L);
            row2.add("entryKey", (Object)"toto");
            ColumnedRow rowAliaser = new ColumnedRow(selectable -> {
                if (selectable == leftTableIdColumn) {
                    return "id";
                }
                if (selectable == entryKeyColumn) {
                    return "entryKey";
                }
                throw new IllegalArgumentException("Column " + selectable + " is not mapped in row");
            });
            RecordId actual = testInstance.assemble(row2, rowAliaser);
            ((ObjectAssert)Assertions.assertThat((Object)actual).withRepresentation((Representation)new StandardRepresentation(){

                protected String fallbackToStringOf(Object object) {
                    return ToStringBuilder.reflectionToString((Object)object, (ToStringStyle)new MultilineRecursiveToStringStyle());
                }
            })).isEqualTo((Object)new RecordId((Object)42L, (Object)"toto"));
        }

        @Test
        <T extends Table<T>, LEFTTABLE extends Table<LEFTTABLE>, RIGHTTABLE extends Table<RIGHTTABLE>> void assemble_mapEntryKeyIsEntityWithSingleColumn_recordIdContainsIdentifiers() {
            Table joinTable = new Table("joinTable");
            Column joinTableIdColumn = joinTable.addColumn("id", Long.TYPE);
            Column entryKeyColumn = joinTable.addColumn("entryKey", String.class);
            Table leftTable = new Table("leftTable");
            Column leftTableIdColumn = leftTable.addColumn("id", Long.TYPE);
            Table rightTable = new Table("rightTable");
            Column rightTableIdColumn = rightTable.addColumn("entryKey", String.class);
            SimpleIdentifierAssembler entryKeyIdentifierAssembler = new SimpleIdentifierAssembler(rightTableIdColumn);
            SimpleIdentifierAssembler sourceIdentifierAssembler = new SimpleIdentifierAssembler(leftTableIdColumn);
            Map primaryKey2ForeignKeyMapping = Collections.emptyMap();
            Map rightTable2EntryKeyMapping = Collections.emptyMap();
            KeyValueRecordMapping.KeyValueRecordIdMapping.RecordIdAssembler testInstance = new KeyValueRecordMapping.KeyValueRecordIdMapping.RecordIdAssembler(joinTable, (IdentifierAssembler)entryKeyIdentifierAssembler, (IdentifierAssembler)sourceIdentifierAssembler, primaryKey2ForeignKeyMapping, rightTable2EntryKeyMapping);
            Row row = new Row();
            row.add("id", (Object)42L);
            row.add("entryKey", (Object)"toto");
            ColumnedRow rowAliaser = new ColumnedRow(selectable -> {
                if (selectable == leftTableIdColumn) {
                    return "id";
                }
                if (selectable == rightTableIdColumn) {
                    return "entryKey";
                }
                throw new IllegalArgumentException("Column " + selectable + " is not mapped in row");
            });
            RecordId actual = testInstance.assemble(row, rowAliaser);
            Assertions.assertThat((Object)actual).isEqualTo((Object)new RecordId((Object)42L, (Object)"toto"));
        }

        @Test
        <T extends Table<T>, LEFTTABLE extends Table<LEFTTABLE>, RIGHTTABLE extends Table<RIGHTTABLE>> void getColumnValues_mapEntryKeyIsASimpleProperty_givesRightValues() {
            Table joinTable = new Table("joinTable");
            Column joinTableIdColumn = joinTable.addColumn("id", Long.TYPE);
            Column entryKeyColumn = joinTable.addColumn("entryKey", String.class);
            Table leftTable = new Table("leftTable");
            Column leftTableIdColumn = leftTable.addColumn("id", Long.TYPE);
            BiFunction<Row, ColumnedRow, String> entryKeyAssembler = (row, columnedRow) -> (String)columnedRow.getValue((Selectable)entryKeyColumn, row);
            SimpleIdentifierAssembler sourceIdentifierAssembler = new SimpleIdentifierAssembler(leftTableIdColumn);
            Maps.ChainingHashMap primaryKey2ForeignKeyMapping = Maps.forHashMap(Column.class, Column.class).add((Object)leftTableIdColumn, (Object)joinTableIdColumn);
            KeyValueRecordMapping.KeyValueRecordIdMapping.RecordIdAssembler testInstance = new KeyValueRecordMapping.KeyValueRecordIdMapping.RecordIdAssembler(joinTable, entryKeyAssembler, s -> Maps.forHashMap(Column.class, String.class).add((Object)entryKeyColumn, s), (IdentifierAssembler)sourceIdentifierAssembler, (Map)primaryKey2ForeignKeyMapping);
            Map actual = testInstance.getColumnValues(new RecordId((Object)42L, (Object)"toto"));
            Assertions.assertThat((Map)actual).isEqualTo((Object)Maps.forHashMap(Column.class, Object.class).add((Object)joinTableIdColumn, (Object)42L).add((Object)entryKeyColumn, (Object)"toto"));
        }

        @Test
        <T extends Table<T>, LEFTTABLE extends Table<LEFTTABLE>, RIGHTTABLE extends Table<RIGHTTABLE>> void getColumnValues_mapEntryKeyIsEntityWithCompositeKey_givesRightValues() {
            Table joinTable = new Table("joinTable");
            Column joinTableIdColumn = joinTable.addColumn("id", Long.TYPE);
            final Column entryKeyProp1Column = joinTable.addColumn("entryKey_prop1", Long.class);
            final Column entryKeyProp2Column = joinTable.addColumn("entryKey_prop2", String.class);
            Table leftTable = new Table("leftTable");
            Column leftTableIdColumn = leftTable.addColumn("id", Long.TYPE);
            Table rightTable = new Table("rightTable");
            final Column rightTableEntryKeyProp1Column = rightTable.addColumn("entryKey_prop1", Long.class);
            final Column rightTableEntryKeyProp2Column = rightTable.addColumn("entryKey_prop2", String.class);
            ComposedIdentifierAssembler entryKeyIdentifierAssembler = new ComposedIdentifierAssembler<EntryKey, RIGHTTABLE>(rightTable){

                public EntryKey assemble(Function<Column<?, ?>, Object> columnValueProvider) {
                    return new EntryKey((Long)columnValueProvider.apply(entryKeyProp1Column), (String)columnValueProvider.apply(entryKeyProp2Column));
                }

                public Map<Column<RIGHTTABLE, Object>, Object> getColumnValues(EntryKey id) {
                    return Maps.forHashMap(Column.class, Object.class).add((Object)rightTableEntryKeyProp1Column, (Object)id.prop1).add((Object)rightTableEntryKeyProp2Column, (Object)id.prop2);
                }
            };
            SimpleIdentifierAssembler sourceIdentifierAssembler = new SimpleIdentifierAssembler(leftTableIdColumn);
            Maps.ChainingHashMap primaryKey2ForeignKeyMapping = Maps.forHashMap(Column.class, Column.class).add((Object)leftTableIdColumn, (Object)joinTableIdColumn);
            Maps.ChainingHashMap rightTable2EntryKeyMapping = Maps.forHashMap(Column.class, Column.class).add((Object)rightTableEntryKeyProp1Column, (Object)entryKeyProp1Column).add((Object)rightTableEntryKeyProp2Column, (Object)entryKeyProp2Column);
            KeyValueRecordMapping.KeyValueRecordIdMapping.RecordIdAssembler testInstance = new KeyValueRecordMapping.KeyValueRecordIdMapping.RecordIdAssembler(joinTable, (IdentifierAssembler)entryKeyIdentifierAssembler, (IdentifierAssembler)sourceIdentifierAssembler, (Map)primaryKey2ForeignKeyMapping, (Map)rightTable2EntryKeyMapping);
            Map actual = testInstance.getColumnValues(new RecordId((Object)42L, (Object)new EntryKey(17L, "toto")));
            Assertions.assertThat((Map)actual).isEqualTo((Object)Maps.forHashMap(Column.class, Object.class).add((Object)joinTableIdColumn, (Object)42L).add((Object)entryKeyProp1Column, (Object)17L).add((Object)entryKeyProp2Column, (Object)"toto"));
        }
    }
}

