/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.ddl;

import java.util.Collections;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.sql.ddl.DDLAppender;
import org.codefilarete.stalactite.sql.ddl.SqlTypeRegistry;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.ForeignKey;
import org.codefilarete.stalactite.sql.ddl.structure.Index;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.ddl.structure.UniqueConstraint;
import org.codefilarete.tool.StringAppender;

public class DDLTableGenerator {
    private final SqlTypeRegistry typeMapping;
    protected final DMLNameProvider dmlNameProvider;

    public DDLTableGenerator(SqlTypeRegistry typeMapping) {
        this(typeMapping, new DMLNameProvider(Collections.emptyMap()));
    }

    public DDLTableGenerator(SqlTypeRegistry typeMapping, DMLNameProvider dmlNameProvider) {
        this.typeMapping = typeMapping;
        this.dmlNameProvider = dmlNameProvider;
    }

    public String generateCreateTable(Table<?> table) {
        DDLAppender sqlCreateTable = new DDLAppender(this.dmlNameProvider, "create table ", table, "(");
        for (Column<?, ?> column : table.getColumns()) {
            this.generateCreateColumn(column, sqlCreateTable);
            sqlCreateTable.cat(", ");
        }
        sqlCreateTable.cutTail(2);
        if (table.getPrimaryKey() != null) {
            this.generateCreatePrimaryKey(table.getPrimaryKey(), sqlCreateTable);
        }
        sqlCreateTable.cat(")");
        return sqlCreateTable.toString();
    }

    protected void generateCreatePrimaryKey(PrimaryKey primaryKey, DDLAppender sqlCreateTable) {
        sqlCreateTable.cat(", primary key (").ccat(primaryKey.getColumns(), (Object)", ").cat((Object)")");
    }

    protected void generateCreateColumn(Column column, DDLAppender sqlCreateTable) {
        sqlCreateTable.cat(column, " ", this.getSqlType(column)).catIf(!column.isNullable(), new Object[]{" not null"});
    }

    protected String getSqlType(Column column) {
        return this.typeMapping.getTypeName(column);
    }

    public String generateCreateIndex(Index index) {
        Table table = index.getTable();
        StringAppender sqlCreateIndex = new DDLAppender(this.dmlNameProvider, "create").catIf(index.isUnique(), new Object[]{" unique"}).cat(new Object[]{" index ", index.getName(), " on ", table, "("}).ccat(index.getColumns(), (Object)", ");
        return sqlCreateIndex.cat((Object)")").toString();
    }

    public String generateCreateForeignKey(ForeignKey foreignKey) {
        Fromable table = foreignKey.getTable();
        StringAppender sqlCreateFK = new DDLAppender(this.dmlNameProvider, "alter table ", table).cat(" add constraint ", foreignKey.getName(), " foreign key(").ccat(foreignKey.getColumns(), (Object)", ").cat((Object)") references ", foreignKey.getTargetTable(), (Object)"(").ccat(foreignKey.getTargetColumns(), (Object)", ");
        return sqlCreateFK.cat((Object)")").toString();
    }

    public String generateCreateUniqueConstraint(UniqueConstraint uniqueConstraint) {
        Table table = uniqueConstraint.getTable();
        StringAppender sqlCreateIndex = new DDLAppender(this.dmlNameProvider, "alter table ").cat(new Object[]{table, " add constraint ", uniqueConstraint.getName(), " unique ", "("}).ccat(uniqueConstraint.getColumns(), (Object)", ");
        return sqlCreateIndex.cat((Object)")").toString();
    }

    public String generateAddColumn(Column column) {
        DDLAppender sqladdColumn = new DDLAppender(this.dmlNameProvider, "alter table ", column.getTable(), " add column ", column, " ", this.getSqlType(column));
        return sqladdColumn.toString();
    }

    public String generateDropTable(Table table) {
        DDLAppender sqlCreateTable = new DDLAppender(this.dmlNameProvider, "drop table ", table);
        return sqlCreateTable.toString();
    }

    public String generateDropTableIfExists(Table table) {
        DDLAppender sqlCreateTable = new DDLAppender(this.dmlNameProvider, "drop table if exists ", table);
        return sqlCreateTable.toString();
    }

    public String generateDropIndex(Index index) {
        DDLAppender sqlCreateTable = new DDLAppender(this.dmlNameProvider, "drop index ", index.getName());
        return sqlCreateTable.toString();
    }

    public String generateDropForeignKey(ForeignKey foreignKey) {
        DDLAppender sqlCreateTable = new DDLAppender(this.dmlNameProvider, "alter table ", foreignKey.getTable(), " drop constraint ", foreignKey.getName());
        return sqlCreateTable.toString();
    }

    public String generateDropColumn(Column column) {
        DDLAppender sqlDropColumn = new DDLAppender(this.dmlNameProvider, "alter table ", column.getTable(), " drop column ", column);
        return sqlDropColumn.toString();
    }
}

