/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.spring.transaction;

import java.sql.Connection;
import javax.sql.DataSource;
import org.codefilarete.stalactite.engine.SeparateTransactionExecutor;
import org.codefilarete.stalactite.sql.spring.transaction.TransactionManagerDataSourceProvider;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

public class PlatformTransactionManagerConnectionProvider
implements SeparateTransactionExecutor {
    private final PlatformTransactionManager transactionManager;
    private final TransactionManagerDataSourceProvider dataSourceProvider;

    public PlatformTransactionManagerConnectionProvider(PlatformTransactionManager transactionManager, TransactionManagerDataSourceProvider dataSourceProvider) {
        this.transactionManager = transactionManager;
        this.dataSourceProvider = dataSourceProvider;
    }

    public Connection giveConnection() {
        if (!TransactionSynchronizationManager.isActualTransactionActive()) {
            throw new IllegalStateException("No active transaction");
        }
        return DataSourceUtils.getConnection((DataSource)this.dataSourceProvider.getDataSource());
    }

    public void executeInNewTransaction(final SeparateTransactionExecutor.JdbcOperation jdbcOperation) {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        transactionTemplate.setPropagationBehavior(3);
        transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                jdbcOperation.execute();
            }
        });
    }
}

