/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.manytomany;

import java.util.Collection;
import java.util.function.Supplier;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.Mutator;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.stalactite.engine.AssociationTableNamingStrategy;
import org.codefilarete.stalactite.engine.CascadeOptions;
import org.codefilarete.stalactite.engine.ColumnNamingStrategy;
import org.codefilarete.stalactite.engine.ForeignKeyNamingStrategy;
import org.codefilarete.stalactite.engine.JoinColumnNamingStrategy;
import org.codefilarete.stalactite.engine.PersisterRegistry;
import org.codefilarete.stalactite.engine.configurer.AssociationRecordMapping;
import org.codefilarete.stalactite.engine.configurer.CascadeConfigurationResult;
import org.codefilarete.stalactite.engine.configurer.IndexedAssociationRecordMapping;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderImpl;
import org.codefilarete.stalactite.engine.configurer.manytomany.ManyToManyRelation;
import org.codefilarete.stalactite.engine.configurer.onetomany.OneToManyRelationConfigurer;
import org.codefilarete.stalactite.engine.runtime.AssociationRecord;
import org.codefilarete.stalactite.engine.runtime.AssociationRecordPersister;
import org.codefilarete.stalactite.engine.runtime.AssociationTable;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.IndexedAssociationTable;
import org.codefilarete.stalactite.engine.runtime.onetomany.AbstractOneToManyWithAssociationTableEngine;
import org.codefilarete.stalactite.engine.runtime.onetomany.ManyRelationDescriptor;
import org.codefilarete.stalactite.engine.runtime.onetomany.OneToManyWithAssociationTableEngine;
import org.codefilarete.stalactite.engine.runtime.onetomany.OneToManyWithIndexedAssociationTableEngine;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.tool.Nullable;

public class ManyToManyRelationConfigurer<SRC, TRGT, SRCID, TRGTID, C1 extends Collection<TRGT>, C2 extends Collection<SRC>> {
    private final Dialect dialect;
    private final ConnectionConfiguration connectionConfiguration;
    private final PersisterRegistry persisterRegistry;
    private final ManyToManyWithAssociationTableConfigurer<SRC, TRGT, SRCID, TRGTID, C1, C2, ?, ?> configurer;
    private final ManyAssociationConfiguration<SRC, TRGT, SRCID, TRGTID, C1, C2, ?, ?> associationConfiguration;

    public ManyToManyRelationConfigurer(ManyToManyRelation<SRC, TRGT, TRGTID, C1, C2> manyToManyRelation, ConfiguredRelationalPersister<SRC, SRCID> sourcePersister, Dialect dialect, ConnectionConfiguration connectionConfiguration, PersisterRegistry persisterRegistry, ForeignKeyNamingStrategy foreignKeyNamingStrategy, JoinColumnNamingStrategy joinColumnNamingStrategy, ColumnNamingStrategy indexColumnNamingStrategy, AssociationTableNamingStrategy associationTableNamingStrategy) {
        this.dialect = dialect;
        this.connectionConfiguration = connectionConfiguration;
        this.persisterRegistry = persisterRegistry;
        PrimaryKey<?, SRCID> leftPrimaryKey = this.lookupSourcePrimaryKey(sourcePersister);
        CascadeOptions.RelationMode maintenanceMode = manyToManyRelation.getRelationMode();
        boolean orphanRemoval = maintenanceMode == CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL;
        boolean writeAuthorized = maintenanceMode != CascadeOptions.RelationMode.READ_ONLY;
        this.associationConfiguration = new ManyAssociationConfiguration(manyToManyRelation, sourcePersister, leftPrimaryKey, foreignKeyNamingStrategy, indexColumnNamingStrategy, orphanRemoval, writeAuthorized);
        this.configurer = new ManyToManyWithAssociationTableConfigurer(this.associationConfiguration, associationTableNamingStrategy, dialect, maintenanceMode == CascadeOptions.RelationMode.ASSOCIATION_ONLY, connectionConfiguration);
    }

    public void configure(PersisterBuilderImpl<TRGT, TRGTID> targetPersisterBuilder) {
        Table targetTable = this.determineTargetTable(((ManyAssociationConfiguration)this.associationConfiguration).manyToManyRelation);
        ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister = targetPersisterBuilder.build(this.dialect, this.connectionConfiguration, this.persisterRegistry, targetTable);
        this.configurer.configure(targetPersister, ((ManyAssociationConfiguration)this.associationConfiguration).manyToManyRelation.isFetchSeparately());
    }

    public CascadeConfigurationResult<SRC, TRGT> configureWithSelectIn2Phases(String tableAlias, ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister, OneToManyRelationConfigurer.FirstPhaseCycleLoadListener<SRC, TRGTID> firstPhaseCycleLoadListener) {
        return this.configurer.configureWithSelectIn2Phases(tableAlias, targetPersister, firstPhaseCycleLoadListener);
    }

    private Table determineTargetTable(ManyToManyRelation<SRC, TRGT, TRGTID, C1, C2> manyToManyRelation) {
        return manyToManyRelation.getTargetTable();
    }

    protected PrimaryKey<?, SRCID> lookupSourcePrimaryKey(ConfiguredRelationalPersister<SRC, SRCID> sourcePersister) {
        return sourcePersister.getMapping().getTargetTable().getPrimaryKey();
    }

    private static class ManyToManyWithAssociationTableConfigurer<SRC, TRGT, SRCID, TRGTID, C1 extends Collection<TRGT>, C2 extends Collection<SRC>, LEFTTABLE extends Table<LEFTTABLE>, RIGHTTABLE extends Table<RIGHTTABLE>>
    extends ConfigurerTemplate<SRC, TRGT, SRCID, TRGTID, C1, C2, LEFTTABLE, RIGHTTABLE> {
        private final AssociationTableNamingStrategy associationTableNamingStrategy;
        private final Dialect dialect;
        private final boolean maintainAssociationOnly;
        private final ConnectionConfiguration connectionConfiguration;
        private AbstractOneToManyWithAssociationTableEngine<SRC, TRGT, SRCID, TRGTID, C1, AssociationRecord, ?> associationTableEngine;

        private ManyToManyWithAssociationTableConfigurer(ManyAssociationConfiguration<SRC, TRGT, SRCID, TRGTID, C1, C2, LEFTTABLE, RIGHTTABLE> manyAssociationConfiguration, AssociationTableNamingStrategy associationTableNamingStrategy, Dialect dialect, boolean maintainAssociationOnly, ConnectionConfiguration connectionConfiguration) {
            super(manyAssociationConfiguration);
            this.associationTableNamingStrategy = associationTableNamingStrategy;
            this.dialect = dialect;
            this.maintainAssociationOnly = maintainAssociationOnly;
            this.connectionConfiguration = connectionConfiguration;
        }

        private void prepare(ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister) {
            Table rightTable = targetPersister.getMapping().getTargetTable();
            PrimaryKey rightPrimaryKey = rightTable.getPrimaryKey();
            this.determineAccessorDefinition(targetPersister);
            String associationTableName = this.associationTableNamingStrategy.giveName(this.accessorDefinition, this.associationConfiguration.leftPrimaryKey, rightPrimaryKey);
            ManyRelationDescriptor manyRelationDescriptor = new ManyRelationDescriptor(arg_0 -> ((ReversibleAccessor)this.associationConfiguration.collectionGetter).get(arg_0), (arg_0, arg_1) -> ((Mutator)this.associationConfiguration.setter).set(arg_0, arg_1), this.associationConfiguration.giveCollectionFactory(), null);
            if (this.associationConfiguration.manyToManyRelation.isOrdered()) {
                this.assignEngineForIndexedAssociation(rightPrimaryKey, associationTableName, manyRelationDescriptor, targetPersister);
            } else {
                this.assignEngineForNonIndexedAssociation(rightPrimaryKey, associationTableName, manyRelationDescriptor, targetPersister);
            }
        }

        @Override
        void configure(ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister, boolean loadSeparately) {
            this.prepare(targetPersister);
            this.associationTableEngine.addSelectCascade(this.associationConfiguration.srcPersister, loadSeparately);
            this.addWriteCascades(this.associationTableEngine);
        }

        @Override
        public CascadeConfigurationResult<SRC, TRGT> configureWithSelectIn2Phases(String tableAlias, ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister, OneToManyRelationConfigurer.FirstPhaseCycleLoadListener<SRC, TRGTID> firstPhaseCycleLoadListener) {
            this.prepare(targetPersister);
            this.associationTableEngine.addSelectCascadeIn2Phases(firstPhaseCycleLoadListener);
            this.addWriteCascades(this.associationTableEngine);
            return new CascadeConfigurationResult<SRC, TRGT>(this.associationTableEngine.getManyRelationDescriptor().getRelationFixer(), this.associationConfiguration.srcPersister);
        }

        private void addWriteCascades(AbstractOneToManyWithAssociationTableEngine<SRC, TRGT, SRCID, TRGTID, C1, ? extends AssociationRecord, ? extends AssociationTable> oneToManyWithAssociationTableEngine) {
            if (this.associationConfiguration.writeAuthorized) {
                oneToManyWithAssociationTableEngine.addInsertCascade(this.maintainAssociationOnly);
                oneToManyWithAssociationTableEngine.addUpdateCascade(this.associationConfiguration.orphanRemoval, this.maintainAssociationOnly);
                oneToManyWithAssociationTableEngine.addDeleteCascade(this.associationConfiguration.orphanRemoval, this.dialect);
            }
        }

        private <ASSOCIATIONTABLE extends AssociationTable<ASSOCIATIONTABLE, LEFTTABLE, RIGHTTABLE, SRCID, TRGTID>> void assignEngineForNonIndexedAssociation(PrimaryKey<RIGHTTABLE, TRGTID> rightPrimaryKey, String associationTableName, ManyRelationDescriptor<SRC, TRGT, C1> manyRelationDescriptor, ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister) {
            boolean createOneSideForeignKey = !this.associationConfiguration.manyToManyRelation.isSourceTablePerClassPolymorphic();
            boolean createManySideForeignKey = !this.associationConfiguration.manyToManyRelation.isTargetTablePerClassPolymorphic();
            AssociationTable intermediaryTable = new AssociationTable(this.associationConfiguration.leftPrimaryKey.getTable().getSchema(), associationTableName, this.associationConfiguration.leftPrimaryKey, rightPrimaryKey, this.accessorDefinition, this.associationTableNamingStrategy, this.associationConfiguration.foreignKeyNamingStrategy, createOneSideForeignKey, createManySideForeignKey);
            AssociationRecordPersister associationPersister = new AssociationRecordPersister(new AssociationRecordMapping(intermediaryTable, this.associationConfiguration.srcPersister.getMapping().getIdMapping().getIdentifierAssembler(), targetPersister.getMapping().getIdMapping().getIdentifierAssembler(), intermediaryTable.getLeftIdentifierColumnMapping(), intermediaryTable.getRightIdentifierColumnMapping()), this.dialect, this.connectionConfiguration);
            this.associationTableEngine = new OneToManyWithAssociationTableEngine(this.associationConfiguration.srcPersister, targetPersister, manyRelationDescriptor, associationPersister, this.dialect.getWriteOperationFactory());
        }

        private <ASSOCIATIONTABLE extends IndexedAssociationTable<ASSOCIATIONTABLE, LEFTTABLE, RIGHTTABLE, SRCID, TRGTID>> void assignEngineForIndexedAssociation(PrimaryKey<RIGHTTABLE, TRGTID> rightPrimaryKey, String associationTableName, ManyRelationDescriptor manyRelationDescriptor, ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister) {
            ManyToManyRelation relation = this.associationConfiguration.manyToManyRelation;
            String indexingColumnName = (String)Nullable.nullable((Object)relation.getIndexingColumnName()).getOr(() -> this.associationConfiguration.getIndexColumnNamingStrategy().giveName(this.accessorDefinition));
            boolean createOneSideForeignKey = !relation.isSourceTablePerClassPolymorphic();
            boolean createManySideForeignKey = !relation.isTargetTablePerClassPolymorphic();
            IndexedAssociationTable intermediaryTable = new IndexedAssociationTable(this.associationConfiguration.leftPrimaryKey.getTable().getSchema(), associationTableName, this.associationConfiguration.leftPrimaryKey, rightPrimaryKey, this.accessorDefinition, this.associationTableNamingStrategy, this.associationConfiguration.foreignKeyNamingStrategy, createOneSideForeignKey, createManySideForeignKey, indexingColumnName);
            intermediaryTable.addForeignKey(this.associationConfiguration.foreignKeyNamingStrategy::giveName, intermediaryTable.getOneSideForeignKey(), (Key)this.associationConfiguration.leftPrimaryKey);
            AssociationRecordPersister indexedAssociationPersister = new AssociationRecordPersister(new IndexedAssociationRecordMapping(intermediaryTable, this.associationConfiguration.srcPersister.getMapping().getIdMapping().getIdentifierAssembler(), targetPersister.getMapping().getIdMapping().getIdentifierAssembler(), intermediaryTable.getLeftIdentifierColumnMapping(), intermediaryTable.getRightIdentifierColumnMapping()), this.dialect, this.connectionConfiguration);
            this.associationTableEngine = new OneToManyWithIndexedAssociationTableEngine(this.associationConfiguration.srcPersister, targetPersister, manyRelationDescriptor, indexedAssociationPersister, intermediaryTable.getIndexColumn(), this.dialect.getWriteOperationFactory());
        }
    }

    private static abstract class ConfigurerTemplate<SRC, TRGT, SRCID, TRGTID, C1 extends Collection<TRGT>, C2 extends Collection<SRC>, LEFTTABLE extends Table<LEFTTABLE>, RIGHTTABLE extends Table<RIGHTTABLE>> {
        protected final ManyAssociationConfiguration<SRC, TRGT, SRCID, TRGTID, C1, C2, LEFTTABLE, RIGHTTABLE> associationConfiguration;
        protected AccessorDefinition accessorDefinition;

        protected ConfigurerTemplate(ManyAssociationConfiguration<SRC, TRGT, SRCID, TRGTID, C1, C2, LEFTTABLE, RIGHTTABLE> associationConfiguration) {
            this.associationConfiguration = associationConfiguration;
        }

        void determineAccessorDefinition(ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister) {
            this.accessorDefinition = new AccessorDefinition(((ManyAssociationConfiguration)this.associationConfiguration).manyToManyRelation.getMethodReference().getDeclaringClass(), AccessorDefinition.giveDefinition(((ManyAssociationConfiguration)this.associationConfiguration).manyToManyRelation.getMethodReference()).getName(), targetPersister.getClassToPersist());
        }

        abstract void configure(ConfiguredRelationalPersister<TRGT, TRGTID> var1, boolean var2);

        public abstract CascadeConfigurationResult<SRC, TRGT> configureWithSelectIn2Phases(String var1, ConfiguredRelationalPersister<TRGT, TRGTID> var2, OneToManyRelationConfigurer.FirstPhaseCycleLoadListener<SRC, TRGTID> var3);
    }

    private static class ManyAssociationConfiguration<SRC, TRGT, SRCID, TRGTID, C1 extends Collection<TRGT>, C2 extends Collection<SRC>, LEFTTABLE extends Table<LEFTTABLE>, RIGHTTABLE extends Table<RIGHTTABLE>> {
        private final ManyToManyRelation<SRC, TRGT, TRGTID, C1, C2> manyToManyRelation;
        private final ConfiguredRelationalPersister<SRC, SRCID> srcPersister;
        private final PrimaryKey<LEFTTABLE, SRCID> leftPrimaryKey;
        private final ForeignKeyNamingStrategy foreignKeyNamingStrategy;
        private final ColumnNamingStrategy indexColumnNamingStrategy;
        private final ReversibleAccessor<SRC, C1> collectionGetter;
        private final Mutator<SRC, C1> setter;
        private final boolean orphanRemoval;
        private final boolean writeAuthorized;

        private ManyAssociationConfiguration(ManyToManyRelation<SRC, TRGT, TRGTID, C1, C2> manyToManyRelation, ConfiguredRelationalPersister<SRC, SRCID> srcPersister, PrimaryKey<LEFTTABLE, SRCID> leftPrimaryKey, ForeignKeyNamingStrategy foreignKeyNamingStrategy, ColumnNamingStrategy indexColumnNamingStrategy, boolean orphanRemoval, boolean writeAuthorized) {
            this.manyToManyRelation = manyToManyRelation;
            this.srcPersister = srcPersister;
            this.leftPrimaryKey = leftPrimaryKey;
            this.foreignKeyNamingStrategy = foreignKeyNamingStrategy;
            this.collectionGetter = manyToManyRelation.getCollectionProvider();
            this.indexColumnNamingStrategy = indexColumnNamingStrategy;
            this.setter = this.collectionGetter.toMutator();
            this.orphanRemoval = orphanRemoval;
            this.writeAuthorized = writeAuthorized;
        }

        public ColumnNamingStrategy getIndexColumnNamingStrategy() {
            return this.indexColumnNamingStrategy;
        }

        protected Supplier<C1> giveCollectionFactory() {
            Supplier collectionFactory = this.manyToManyRelation.getCollectionFactory();
            if (collectionFactory == null) {
                collectionFactory = BeanRelationFixer.giveCollectionFactory((Class)this.manyToManyRelation.getMethodReference().getPropertyType());
            }
            return collectionFactory;
        }
    }
}

