/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorByMethodReference;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.stalactite.engine.ColumnOptions;
import org.codefilarete.stalactite.engine.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.MappingConfigurationException;
import org.codefilarete.stalactite.engine.MappingEase;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.model.City;
import org.codefilarete.stalactite.engine.model.Country;
import org.codefilarete.stalactite.engine.model.Person;
import org.codefilarete.stalactite.engine.runtime.ConfiguredPersister;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.id.StatefulIdentifierAlreadyAssignedIdentifierPolicy;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.query.EntityCriteriaSupport;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.tool.collection.Maps;
import org.codefilarete.tool.exception.Exceptions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class EntityCriteriaSupportTest {
    EntityCriteriaSupportTest() {
    }

    @Test
    void apiUsage() {
        Dialect dialect = new Dialect();
        dialect.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        dialect.getSqlTypeRegistry().put(Identifier.class, "bigint");
        ConfiguredPersister persister = (ConfiguredPersister)MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.afterInsert()).map(Country::getName).mapOneToOne(Country::getCapital, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName)).build(new PersistenceContext((ConnectionProvider)Mockito.mock(ConnectionProvider.class), dialect));
        EntityCriteriaSupport countryEntityCriteriaSupport = new EntityCriteriaSupport(persister.getMapping()).and(Country::getId, (ConditionalOperator)Operators.in((Object[])new Object[]{"11"})).and(Country::getName, (ConditionalOperator)Operators.eq((Object)"toto")).and(Country::getName, (ConditionalOperator)Operators.between((Object)"11", (Object)"")).and(Country::getName, (ConditionalOperator)Operators.gteq((Object)"11")).and(Country::setName, (ConditionalOperator)Operators.in((Object[])new String[]{"11"})).and(Country::setName, (ConditionalOperator)Operators.between((Object)"11", (Object)"")).and(Country::setName, (ConditionalOperator)Operators.gteq((Object)"11")).or(Country::getId, (ConditionalOperator)Operators.in((Object[])new Object[]{"11"})).or(Country::getName, (ConditionalOperator)Operators.eq((Object)"toto")).or(Country::getName, (ConditionalOperator)Operators.between((Object)"11", (Object)"")).or(Country::getName, (ConditionalOperator)Operators.gteq((Object)"11")).or(Country::setName, (ConditionalOperator)Operators.in((Object[])new String[]{"11"})).or(Country::setName, (ConditionalOperator)Operators.between((Object)"11", (Object)"")).or(Country::setName, (ConditionalOperator)Operators.gteq((Object)"11"));
        persister.selectWhere(Country::getCapital, City::getId, (ConditionalOperator)Operators.gteq((Object)"11")).and(Country::getCapital, City::getId, (ConditionalOperator)Operators.gteq((Object)"11"));
    }

    @Test
    void graphNode_getColumn() {
        Dialect dialect = new Dialect();
        dialect.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        PersistenceContext dummyPersistenceContext = new PersistenceContext((ConnectionProvider)Mockito.mock(ConnectionProvider.class), dialect);
        Table countryTable = new Table("Country");
        Column nameColumn = countryTable.addColumn("name", String.class);
        EntityMapping mappingStrategy = ((ConfiguredPersister)MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE, (Table)countryTable).mapKey(Country::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.afterInsert()).map(Country::getName).build(dummyPersistenceContext)).getMapping();
        EntityCriteriaSupport.EntityGraphNode testInstance = new EntityCriteriaSupport.EntityGraphNode(mappingStrategy);
        Assertions.assertThat((Object)testInstance.giveColumn(AccessorChain.chain(Country::getName).getAccessors())).isEqualTo((Object)nameColumn);
    }

    @Test
    void graphNode_getColumn_withRelationOneToOne() {
        Dialect dialect = new Dialect();
        dialect.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        dialect.getSqlTypeRegistry().put(Identifier.class, "bigint");
        PersistenceContext dummyPersistenceContext = new PersistenceContext((ConnectionProvider)Mockito.mock(ConnectionProvider.class), dialect);
        Table countryTable = new Table("Country");
        Table cityTable = new Table("City");
        Column nameColumn = cityTable.addColumn("name", String.class);
        EntityMapping mappingStrategy = ((ConfiguredPersister)MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE, (Table)countryTable).mapKey(Country::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.afterInsert()).map(Country::getName).mapOneToOne(Country::getCapital, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName), cityTable).build(dummyPersistenceContext)).getMapping();
        EntityCriteriaSupport.EntityGraphNode testInstance = new EntityCriteriaSupport.EntityGraphNode(mappingStrategy);
        testInstance.registerRelation((ValueAccessPoint)new AccessorByMethodReference(Country::getCapital), (ConfiguredRelationalPersister)dummyPersistenceContext.getPersister(City.class));
        Assertions.assertThat((Object)testInstance.giveColumn(AccessorChain.chain(Country::getCapital, City::getName).getAccessors())).isEqualTo((Object)nameColumn);
    }

    @Test
    void graphNode_getColumn_withRelationOneToMany() {
        Dialect dialect = new Dialect();
        dialect.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        PersistenceContext dummyPersistenceContext = new PersistenceContext((ConnectionProvider)Mockito.mock(ConnectionProvider.class), dialect);
        Table countryTable = new Table("Country");
        Table cityTable = new Table("City");
        Column nameColumn = cityTable.addColumn("name", String.class);
        EntityMapping mappingStrategy = ((ConfiguredPersister)MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE, (Table)countryTable).mapKey(Country::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.afterInsert()).map(Country::getName).mapOneToMany(Country::getCities, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName), cityTable).build(dummyPersistenceContext)).getMapping();
        EntityCriteriaSupport.EntityGraphNode testInstance = new EntityCriteriaSupport.EntityGraphNode(mappingStrategy);
        testInstance.registerRelation((ValueAccessPoint)new AccessorByMethodReference(Country::getCities), (ConfiguredRelationalPersister)dummyPersistenceContext.getPersister(City.class));
        Assertions.assertThat((Object)testInstance.giveColumn(new AccessorChain(new Accessor[]{new AccessorByMethodReference(Country::getCities), new AccessorByMethodReference(City::getName)}).getAccessors())).isEqualTo((Object)nameColumn);
    }

    @Test
    void graphNode_getColumn_doesntExist_throwsException() {
        Dialect dialect = new Dialect();
        dialect.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        PersistenceContext dummyPersistenceContext = new PersistenceContext((ConnectionProvider)Mockito.mock(ConnectionProvider.class), dialect);
        Table countryTable = new Table("Country");
        EntityMapping mappingStrategy = ((ConfiguredPersister)MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE, (Table)countryTable).mapKey(Country::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.afterInsert()).build(dummyPersistenceContext)).getMapping();
        EntityCriteriaSupport.EntityGraphNode testInstance = new EntityCriteriaSupport.EntityGraphNode(mappingStrategy);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> testInstance.giveColumn(AccessorChain.chain(Country::getName).getAccessors())).extracting(t -> (MappingConfigurationException)Exceptions.findExceptionInCauses((Throwable)t, MappingConfigurationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Error while looking for column of Country::getName : it is not declared in mapping of o.c.s.e.m.Country");
    }

    @Test
    void graphNode_getColumn_many_doesntExist_throwsException() {
        Dialect dialect = new Dialect();
        dialect.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        PersistenceContext dummyPersistenceContext = new PersistenceContext((ConnectionProvider)Mockito.mock(ConnectionProvider.class), dialect);
        Table countryTable = new Table("Country");
        EntityMapping mappingStrategy = ((ConfiguredPersister)MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE, (Table)countryTable).mapKey(Country::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.afterInsert()).build(dummyPersistenceContext)).getMapping();
        EntityCriteriaSupport testInstance = new EntityCriteriaSupport(mappingStrategy);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> testInstance.andMany(Country::getCities, City::getName, (ConditionalOperator)Operators.eq((Object)"Grenoble"))).extracting(t -> (MappingConfigurationException)Exceptions.findExceptionInCauses((Throwable)t, MappingConfigurationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Error while looking for column of Country::getCities > City::getName : it is not declared in mapping of o.c.s.e.m.Country");
    }

    @Test
    void hasCollectionCriteria_noCollectionCriteria_returnsFalse() {
        Table personTable = new Table("Person");
        Column nameColumn = personTable.addColumn("name", String.class);
        EntityMapping entityMappingMock = (EntityMapping)Mockito.mock(EntityMapping.class);
        Mockito.when((Object)entityMappingMock.getPropertyToColumn()).thenReturn((Object)Maps.forHashMap(ReversibleAccessor.class, Column.class).add((Object)Accessors.accessor(Person::getName), (Object)nameColumn));
        EntityCriteriaSupport testInstance = new EntityCriteriaSupport(entityMappingMock);
        Assertions.assertThat((boolean)testInstance.hasCollectionCriteria()).isFalse();
        testInstance.and(Person::getName, (ConditionalOperator)Operators.eq((Object)""));
        Assertions.assertThat((boolean)testInstance.hasCollectionCriteria()).isFalse();
    }

    @Test
    void hasCollectionCriteria_embeddedCollectionCriteria_returnsTrue() {
        Table personTable = new Table("Person");
        Column nameColumn = personTable.addColumn("name", String.class);
        EntityCriteriaSupport testInstance = new EntityCriteriaSupport((EntityMapping)Mockito.mock(EntityMapping.class));
        ConfiguredRelationalPersister persisterMock = (ConfiguredRelationalPersister)Mockito.mock(ConfiguredRelationalPersister.class);
        Mockito.when((Object)persisterMock.getColumn(ArgumentMatchers.anyList())).thenReturn((Object)nameColumn);
        testInstance.registerRelation((ValueAccessPoint)new AccessorByMethodReference(Person::getNicknames), persisterMock);
        testInstance.and(Person::getNicknames, (ConditionalOperator)Operators.eq((Object)""));
        Assertions.assertThat((boolean)testInstance.hasCollectionCriteria()).isTrue();
    }

    @Test
    void hasCollectionCriteria_manyCriteria_returnsTrue() {
        Table personTable = new Table("Person");
        Column nameColumn = personTable.addColumn("name", String.class);
        EntityCriteriaSupport testInstance = new EntityCriteriaSupport((EntityMapping)Mockito.mock(EntityMapping.class));
        ConfiguredRelationalPersister persisterMock = (ConfiguredRelationalPersister)Mockito.mock(ConfiguredRelationalPersister.class);
        Mockito.when((Object)persisterMock.getColumn(ArgumentMatchers.anyList())).thenReturn((Object)nameColumn);
        testInstance.registerRelation((ValueAccessPoint)new AccessorByMethodReference(Country::getCities), persisterMock);
        testInstance.andMany(Country::getCities, City::getName, (ConditionalOperator)Operators.eq((Object)""));
        Assertions.assertThat((boolean)testInstance.hasCollectionCriteria()).isTrue();
    }
}

