/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.model;

import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.operator.Between;
import org.codefilarete.stalactite.query.model.operator.Cast;
import org.codefilarete.stalactite.query.model.operator.Coalesce;
import org.codefilarete.stalactite.query.model.operator.Count;
import org.codefilarete.stalactite.query.model.operator.Equals;
import org.codefilarete.stalactite.query.model.operator.Greater;
import org.codefilarete.stalactite.query.model.operator.In;
import org.codefilarete.stalactite.query.model.operator.IsNull;
import org.codefilarete.stalactite.query.model.operator.Like;
import org.codefilarete.stalactite.query.model.operator.Lower;
import org.codefilarete.stalactite.query.model.operator.Max;
import org.codefilarete.stalactite.query.model.operator.Min;
import org.codefilarete.stalactite.query.model.operator.Sum;

public interface Operators {
    public static <O> Equals<O> eq(O value) {
        return new Equals<O>(value);
    }

    public static <I extends ConditionalOperator> I not(I operator) {
        operator.not();
        return operator;
    }

    public static Lower lt(Object value) {
        return new Lower<Object>(value);
    }

    public static Lower lteq(Object value) {
        return new Lower<Object>(value, true);
    }

    public static <O> Greater<O> gt(O value) {
        return new Greater<O>(value);
    }

    public static <O> Greater<O> gteq(O value) {
        return new Greater<O>(value, true);
    }

    public static <O> Between<O> between(O value1, O value2) {
        return new Between<O>(value1, value2);
    }

    public static <O> In<O> in(Iterable<O> value) {
        return new In<O>(value);
    }

    public static <O> In<O> in(O ... value) {
        return new In<O>(value);
    }

    public static IsNull isNull() {
        return new IsNull();
    }

    public static IsNull isNotNull() {
        return Operators.not(Operators.isNull());
    }

    public static Like like(CharSequence value) {
        return new Like(value);
    }

    public static Like contains(CharSequence value) {
        return new Like(value, true, true);
    }

    public static Like startsWith(CharSequence value) {
        return new Like(value, false, true);
    }

    public static Like endsWith(CharSequence value) {
        return new Like(value, true, false);
    }

    public static <N extends Number> Sum<N> sum(Selectable<N> column) {
        return new Sum<N>(column);
    }

    public static Count count(Selectable<?> ... columns) {
        return new Count(columns);
    }

    public static Count count(Iterable<? extends Selectable<?>> columns) {
        return new Count(columns);
    }

    public static <N extends Number> Min<N> min(Selectable<N> column) {
        return new Min<N>(column);
    }

    public static <N extends Number> Max<N> max(Selectable<N> column) {
        return new Max<N>(column);
    }

    public static <C> Cast<C> cast(String expression, Class<C> javaType) {
        return new Cast<C>(expression, javaType);
    }

    public static <C> Coalesce<C> coalesce(Selectable<C> column, Selectable<C> ... columns) {
        return new Coalesce<C>(column, (Object[])columns);
    }
}

