/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.result;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.sql.result.ColumnConsumer;
import org.codefilarete.stalactite.sql.result.InMemoryResultSet;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.binder.DefaultResultSetReaders;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Maps;
import org.codefilarete.tool.trace.ModifiableInt;
import org.junit.jupiter.api.Test;

public class ColumnConsumerTest {
    @Test
    public void testAssemble() throws SQLException {
        ModifiableInt targetInstance = new ModifiableInt();
        ColumnConsumer testInstance = new ColumnConsumer("a", DefaultResultSetReaders.INTEGER_READER, ModifiableInt::increment);
        InMemoryResultSet resultSet = new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingMap[]{Maps.asMap((Object)"a", (Object)42).add((Object)"b", (Object)-42), Maps.asMap((Object)"a", (Object)666)}));
        resultSet.next();
        testInstance.assemble((Object)targetInstance, (ResultSet)resultSet);
        Assertions.assertThat((int)targetInstance.getValue()).isEqualTo(42);
        resultSet.next();
        testInstance.assemble((Object)targetInstance, (ResultSet)resultSet);
        Assertions.assertThat((int)targetInstance.getValue()).isEqualTo(708);
    }

    @Test
    public void testCopyWithAlias() throws SQLException {
        ModifiableInt targetInstance = new ModifiableInt();
        ColumnConsumer srcInstance = new ColumnConsumer("a", DefaultResultSetReaders.INTEGER_READER, ModifiableInt::increment);
        ColumnConsumer testInstance = srcInstance.copyWithAliases(n -> n + "_new");
        InMemoryResultSet resultSet = new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingMap[]{Maps.asMap((Object)"a_new", (Object)42).add((Object)"b_new", (Object)-42), Maps.asMap((Object)"a_new", (Object)666)}));
        resultSet.next();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> srcInstance.assemble((Object)targetInstance, (ResultSet)resultSet)).isInstanceOf(SQLStatement.BindingException.class)).hasMessage("Error while reading column 'a'").hasCause((Throwable)new SQLException("Column doesn't exist : a"));
        testInstance.assemble((Object)targetInstance, (ResultSet)resultSet);
        Assertions.assertThat((int)targetInstance.getValue()).isEqualTo(42);
        resultSet.next();
        testInstance.assemble((Object)targetInstance, (ResultSet)resultSet);
        Assertions.assertThat((int)targetInstance.getValue()).isEqualTo(708);
    }
}

