/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.builder;

import java.util.HashMap;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.builder.PreparedSQLBuilder;
import org.codefilarete.stalactite.query.builder.PreparedSQLWrapper;
import org.codefilarete.stalactite.query.builder.QuerySQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.SQLAppender;
import org.codefilarete.stalactite.query.builder.SQLBuilder;
import org.codefilarete.stalactite.query.builder.StringAppenderWrapper;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.Union;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.trace.ModifiableInt;

public class UnionSQLBuilderFactory {
    private static final String UNION_ALL_SEPARATOR = ") union all (";

    public UnionSQLBuilder unionBuilder(Union union, QuerySQLBuilderFactory querySQLBuilderFactory) {
        return new UnionSQLBuilder(union, querySQLBuilderFactory);
    }

    public static class UnionSQLBuilder
    implements SQLBuilder,
    PreparedSQLBuilder {
        private final Union union;
        private final QuerySQLBuilderFactory querySQLBuilderFactory;

        public UnionSQLBuilder(Union union, QuerySQLBuilderFactory querySQLBuilderFactory) {
            this.union = union;
            this.querySQLBuilderFactory = querySQLBuilderFactory;
        }

        @Override
        public CharSequence toSQL() {
            StringAppender result = new StringAppender(500);
            this.toSQL(new StringAppenderWrapper(result, new DMLNameProvider(this.union.getAliases()::get)));
            return result.toString();
        }

        public void toSQL(SQLAppender sqlAppender) {
            UnionGenerator sql = new UnionGenerator(sqlAppender);
            this.union.getQueries().forEach(query -> {
                sql.cat(query);
                sqlAppender.cat(" union all ", new String[0]);
            });
            sqlAppender.removeLastChars(" union all ".length());
        }

        @Override
        public PreparedSQL toPreparedSQL() {
            KeepOrderSet<Query> queries = this.union.getQueries();
            StringAppender unionSql = new StringAppender();
            HashMap parameterBinders = new HashMap();
            HashMap values = new HashMap();
            ModifiableInt parameterIndex = new ModifiableInt(1);
            queries.forEach(query -> {
                PreparedSQL preparedSql = this.querySQLBuilderFactory.queryBuilder((Query)query).toPreparedSQL();
                unionSql.cat((Object)preparedSql.getSQL(), (Object)UnionSQLBuilderFactory.UNION_ALL_SEPARATOR);
                preparedSql.getValues().values().forEach(value -> {
                    values.put(parameterIndex.getValue(), value);
                    parameterBinders.put(parameterIndex.getValue(), preparedSql.getParameterBinder((Object)(1 + parameterIndex.getValue() % preparedSql.getValues().size())));
                    parameterIndex.increment();
                });
            });
            unionSql.cutTail(UnionSQLBuilderFactory.UNION_ALL_SEPARATOR.length()).wrap((Object)"(", (Object)")");
            PreparedSQL preparedSQL = new PreparedSQL(unionSql.toString(), parameterBinders);
            preparedSQL.setValues(values);
            return preparedSQL;
        }

        public PreparedSQL toPreparedSQL(PreparedSQLWrapper preparedSQLWrapper) {
            KeepOrderSet<Query> queries = this.union.getQueries();
            HashMap parameterBinders = new HashMap();
            HashMap values = new HashMap();
            ModifiableInt parameterIndex = new ModifiableInt(1);
            preparedSQLWrapper.cat("(", new String[0]);
            queries.forEach(query -> {
                PreparedSQL preparedSql = this.querySQLBuilderFactory.queryBuilder((Query)query).toPreparedSQL(preparedSQLWrapper);
                preparedSQLWrapper.cat(UnionSQLBuilderFactory.UNION_ALL_SEPARATOR, new String[0]);
                preparedSql.getValues().values().forEach(value -> {
                    values.put(parameterIndex.getValue(), value);
                    parameterBinders.put(parameterIndex.getValue(), preparedSql.getParameterBinder((Object)(1 + parameterIndex.getValue() % preparedSql.getValues().size())));
                    parameterIndex.increment();
                });
            });
            preparedSQLWrapper.removeLastChars(UnionSQLBuilderFactory.UNION_ALL_SEPARATOR.length());
            preparedSQLWrapper.cat(")", new String[0]);
            PreparedSQL preparedSQL = new PreparedSQL(preparedSQLWrapper.toString(), parameterBinders);
            preparedSQL.setValues(values);
            return preparedSQL;
        }

        private class UnionGenerator {
            private final SQLAppender sqlAppender;

            private UnionGenerator(SQLAppender sqlAppender) {
                this.sqlAppender = sqlAppender;
            }

            private void cat(Query query) {
                QuerySQLBuilderFactory.QuerySQLBuilder unionBuilder = UnionSQLBuilder.this.querySQLBuilderFactory.queryBuilder(query);
                unionBuilder.toSQL(this.sqlAppender);
            }
        }
    }
}

