/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql;

import java.sql.Connection;
import javax.annotation.Nonnull;
import org.codefilarete.stalactite.sql.CommitListener;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.RollbackListener;
import org.codefilarete.stalactite.sql.TransactionAwareConnexionWrapper;
import org.codefilarete.stalactite.sql.TransactionObserver;

public class TransactionAwareConnectionProvider
implements ConnectionProvider,
TransactionObserver {
    private final TransactionAwareConnexionWrapper transactionAwareConnexionWrapper = new TransactionAwareConnexionWrapper();
    private final ConnectionProvider delegate;

    public TransactionAwareConnectionProvider(ConnectionProvider connectionProvider) {
        this.delegate = connectionProvider;
    }

    public ConnectionProvider getDelegate() {
        return this.delegate;
    }

    @Override
    @Nonnull
    public Connection giveConnection() {
        Connection connection = this.delegate.giveConnection();
        this.transactionAwareConnexionWrapper.setDelegate(connection);
        return this.transactionAwareConnexionWrapper;
    }

    @Override
    public void addCommitListener(CommitListener commitListener) {
        this.transactionAwareConnexionWrapper.addCommitListener(commitListener);
    }

    @Override
    public void addRollbackListener(RollbackListener rollbackListener) {
        this.transactionAwareConnexionWrapper.addRollbackListener(rollbackListener);
    }
}

