/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.builder;

import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.builder.SQLAppender;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.operator.Cast;
import org.codefilarete.stalactite.query.model.operator.Count;
import org.codefilarete.stalactite.query.model.operator.SQLFunction;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;

public class FunctionSQLBuilderFactory {
    private final JavaTypeToSqlTypeMapping javaTypeToSqlTypeMapping;

    public FunctionSQLBuilderFactory(JavaTypeToSqlTypeMapping javaTypeToSqlTypeMapping) {
        this.javaTypeToSqlTypeMapping = javaTypeToSqlTypeMapping;
    }

    public FunctionSQLBuilder functionSQLBuilder(DMLNameProvider dmlNameProvider) {
        return new FunctionSQLBuilder(dmlNameProvider, this.javaTypeToSqlTypeMapping);
    }

    public static class FunctionSQLBuilder {
        private final DMLNameProvider dmlNameProvider;
        private final JavaTypeToSqlTypeMapping javaTypeToSqlTypeMapping;

        public FunctionSQLBuilder(DMLNameProvider dmlNameProvider, JavaTypeToSqlTypeMapping javaTypeToSqlTypeMapping) {
            this.dmlNameProvider = dmlNameProvider;
            this.javaTypeToSqlTypeMapping = javaTypeToSqlTypeMapping;
        }

        public <N> void cat(SQLFunction<N> operator, SQLAppender sql) {
            if (operator instanceof Cast) {
                this.catCast((Cast)operator, sql);
            } else {
                sql.cat(operator.getExpression(), "(");
                if (operator instanceof Count && ((Count)operator).isDistinct()) {
                    sql.cat("distinct ", new String[0]);
                }
                for (Object argument : operator.getArguments()) {
                    if (argument instanceof SQLFunction) {
                        this.cat((SQLFunction)argument, sql);
                    } else if (argument instanceof Selectable) {
                        sql.cat(this.dmlNameProvider.getName((Selectable)argument), new String[0]);
                    } else if (argument instanceof CharSequence) {
                        sql.cat(argument.toString(), new String[0]);
                    }
                    sql.cat(", ", new String[0]);
                }
                sql.removeLastChars(2).cat(")", new String[0]);
            }
        }

        public void catCast(Cast<?> cast, SQLAppender sqlAppender) {
            sqlAppender.cat(cast.getExpression(), "(");
            if (cast.getCastTarget() instanceof SQLFunction) {
                this.cat((SQLFunction)cast.getCastTarget(), sqlAppender);
            } else {
                sqlAppender.catValue(cast.getCastTarget());
            }
            sqlAppender.cat(" as ", this.javaTypeToSqlTypeMapping.getTypeName(cast.getJavaType(), cast.getTypeSize()), ")");
        }
    }
}

