/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.mapping.id.sequence;

import java.util.Map;
import javax.annotation.Nullable;
import org.codefilarete.stalactite.mapping.id.sequence.SequenceStorageOptions;
import org.codefilarete.tool.bean.Objects;
import org.codefilarete.tool.function.ConverterRegistry;

public class PooledHiLoSequenceOptions {
    private static final String POOL_SIZE_PARAM = "poolSize";
    private static final String SEQUENCE_NAME_PARAM = "sequenceName";
    private static final String TABLE_PARAM = "table";
    private static final String SEQUENCE_COLUMN_PARAM = "sequenceNameColumn";
    private static final String VALUE_COLUMN_PARAM = "valueColumn";
    private static final ConverterRegistry CONVERTER_REGISTRY = ConverterRegistry.DEFAULT;
    private final int poolSize;
    private final String sequenceName;
    private final SequenceStorageOptions storageOptions;
    private final long initialValue;

    public PooledHiLoSequenceOptions(String sequenceName) {
        this(50, sequenceName);
    }

    public PooledHiLoSequenceOptions(int poolSize, String sequenceName) {
        this(poolSize, sequenceName, SequenceStorageOptions.DEFAULT, 1L);
    }

    public PooledHiLoSequenceOptions(int poolSize, String sequenceName, SequenceStorageOptions storageOptions) {
        this(poolSize, sequenceName, storageOptions, 1L);
    }

    public PooledHiLoSequenceOptions(int poolSize, String sequenceName, @Nullable SequenceStorageOptions storageOptions, long initialValue) {
        this.poolSize = poolSize;
        this.sequenceName = sequenceName;
        this.storageOptions = (SequenceStorageOptions)Objects.preventNull((Object)storageOptions, (Object)SequenceStorageOptions.DEFAULT);
        this.initialValue = initialValue;
    }

    public PooledHiLoSequenceOptions(Map<String, Object> configuration) {
        this(CONVERTER_REGISTRY.asInteger(configuration.get(POOL_SIZE_PARAM)), CONVERTER_REGISTRY.asString(configuration.get(SEQUENCE_NAME_PARAM)), new SequenceStorageOptions(CONVERTER_REGISTRY.asString(configuration.get(TABLE_PARAM)), CONVERTER_REGISTRY.asString(configuration.get(SEQUENCE_COLUMN_PARAM)), CONVERTER_REGISTRY.asString(configuration.get(VALUE_COLUMN_PARAM))));
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public SequenceStorageOptions getStorageOptions() {
        return this.storageOptions;
    }

    public long getInitialValue() {
        return this.initialValue;
    }
}

