/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Random;
import java.util.function.Predicate;
import javax.sql.DataSource;
import org.codefilarete.stalactite.sql.UrlAwareDataSource;
import org.codefilarete.stalactite.sql.statement.SQLOperationITTest;
import org.codefilarete.stalactite.sql.test.DatabaseHelper;
import org.codefilarete.stalactite.sql.test.H2DatabaseHelper;
import org.h2.engine.SessionLocal;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbcx.JdbcDataSource;
import org.h2.schema.Schema;
import org.h2.table.Table;

class SQLOperationH2Test
extends SQLOperationITTest {
    SQLOperationH2Test() {
    }

    public DataSource giveDataSource() {
        return new ConcurrentH2InMemoryDataSource();
    }

    protected DatabaseHelper giveDatabaseHelper() {
        return new H2DatabaseHelper();
    }

    protected void lockTable(Connection lockingConnection) {
        SessionLocal session;
        try {
            session = (SessionLocal)lockingConnection.unwrap(JdbcConnection.class).getSession();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        Schema schema = session.getDatabase().getSchema(session.getCurrentSchemaName());
        Table table = schema.findTableOrView(session, "TOTO");
        table.lock(session, 2);
    }

    String giveLockStatement() {
        return null;
    }

    Predicate<Throwable> giveCancelOperationPredicate() {
        return Objects::isNull;
    }

    public static class ConcurrentH2InMemoryDataSource
    extends UrlAwareDataSource {
        private final JdbcDataSource delegate = new JdbcDataSource();

        public ConcurrentH2InMemoryDataSource() {
            super("jdbc:h2:mem:test" + Integer.toHexString(new Random().nextInt()) + ";LOCK_TIMEOUT=5000");
            this.delegate.setUrl(this.getUrl());
            this.delegate.setUser("sa");
            this.delegate.setPassword("");
            this.setDelegate((DataSource)this.delegate);
        }
    }
}

