/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.spring.repository.config;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import org.codefilarete.stalactite.sql.spring.repository.StalactiteRepository;
import org.codefilarete.stalactite.sql.spring.repository.StalactiteRepositoryFactoryBean;
import org.codefilarete.stalactite.sql.spring.repository.config.EnableStalactiteRepositoriesRepositoryConfigurationSource;
import org.codefilarete.stalactite.sql.spring.repository.config.InspectionClassLoader;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.io.ResourceLoader;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.DefaultRepositoryConfiguration;
import org.springframework.data.repository.config.RepositoryConfiguration;
import org.springframework.data.repository.config.RepositoryConfigurationExtension;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class StalactiteRepositoryConfigExtension
extends RepositoryConfigurationExtensionSupport {
    private static final String DEFAULT_TRANSACTION_MANAGER_BEAN_NAME = "transactionManager";
    private static final String ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE = "enableDefaultTransactions";

    public String getModuleName() {
        return "Stalactite";
    }

    public String getRepositoryFactoryBeanClassName() {
        return StalactiteRepositoryFactoryBean.class.getName();
    }

    protected String getModulePrefix() {
        return this.getModuleName().toLowerCase(Locale.US);
    }

    protected Collection<Class<?>> getIdentifyingTypes() {
        return Collections.singleton(StalactiteRepository.class);
    }

    public void postProcess(BeanDefinitionBuilder builder, RepositoryConfigurationSource source) {
        Optional transactionManagerRef = source.getAttribute("transactionManagerRef");
        builder.addPropertyValue(DEFAULT_TRANSACTION_MANAGER_BEAN_NAME, (Object)transactionManagerRef.orElse(DEFAULT_TRANSACTION_MANAGER_BEAN_NAME));
    }

    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        AnnotationAttributes attributes = config.getAttributes();
        builder.addPropertyValue(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE, (Object)attributes.getBoolean(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE));
    }

    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource config) {
        Optional enableDefaultTransactions = config.getAttribute(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE);
        if (enableDefaultTransactions.isPresent() && StringUtils.hasText((String)((String)enableDefaultTransactions.get()))) {
            builder.addPropertyValue(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE, enableDefaultTransactions.get());
        }
    }

    protected ClassLoader getConfigurationInspectionClassLoader(ResourceLoader loader) {
        ClassLoader classLoader = loader.getClassLoader();
        return classLoader != null && LazyJvmAgent.isActive(loader.getClassLoader()) ? new InspectionClassLoader(loader.getClassLoader()) : loader.getClassLoader();
    }

    protected <T extends RepositoryConfigurationSource> RepositoryConfiguration<T> getRepositoryConfiguration(BeanDefinition definition, T configSource) {
        EnableStalactiteRepositoriesRepositoryConfigurationSource repositoryConfigurationSource = new EnableStalactiteRepositoriesRepositoryConfigurationSource((AnnotationRepositoryConfigurationSource)configSource);
        return new DefaultRepositoryConfiguration((RepositoryConfigurationSource)repositoryConfigurationSource, definition, (RepositoryConfigurationExtension)this);
    }

    static class LazyJvmAgent {
        private static final Set<String> AGENT_CLASSES;

        private LazyJvmAgent() {
        }

        static boolean isActive(@Nullable ClassLoader classLoader) {
            return AGENT_CLASSES.stream().anyMatch(agentClass -> ClassUtils.isPresent((String)agentClass, (ClassLoader)classLoader));
        }

        static {
            LinkedHashSet<String> agentClasses = new LinkedHashSet<String>();
            agentClasses.add("org.springframework.instrument.InstrumentationSavingAgent");
            agentClasses.add("org.eclipse.persistence.internal.jpa.deployment.JavaSECMPInitializerAgent");
            AGENT_CLASSES = Collections.unmodifiableSet(agentClasses);
        }
    }
}

