/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.mapping;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.PropertyAccessor;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.bean.FieldIterator;
import org.codefilarete.tool.collection.Iterables;

public class PersistentFieldHarvester {
    private Map<PropertyAccessor, Column> fieldToColumn;
    private Map<String, Field> nameTofield;

    public List<Field> getFields(Class clazz) {
        FieldFilter fieldVisitor = this.getFieldVisitor();
        return Iterables.stream((Iterator)new FieldIterator(clazz)).filter(fieldVisitor).collect(Collectors.toList());
    }

    public Map<PropertyAccessor, Column> getFieldToColumn() {
        return this.fieldToColumn;
    }

    public <C, T extends Table<T>> Map<PropertyAccessor<C, Object>, Column<T, Object>> mapFields(Class<C> clazz, T targetTable) {
        List<Field> fields = this.getFields(clazz);
        Map<String, Column<T, Object>> mapColumnsOnName = targetTable.mapColumnsOnName();
        this.fieldToColumn = new LinkedHashMap<PropertyAccessor, Column>(5);
        this.nameTofield = new HashMap<String, Field>(5);
        for (Field field : fields) {
            Column<T, Object> column = mapColumnsOnName.get(field.getName());
            if (column == null) {
                column = this.newColumn(targetTable, field);
            }
            this.fieldToColumn.put(Accessors.propertyAccessor((Field)field), column);
            this.nameTofield.put(field.getName(), field);
        }
        return this.fieldToColumn;
    }

    protected <T extends Table> Column<T, Object> newColumn(T targetTable, Field field) {
        return this.newColumn(targetTable, this.buildColumnName(field), field.getType());
    }

    protected <T extends Table> Column<T, Object> newColumn(T targetTable, String fieldName, Class type) {
        return targetTable.addColumn(fieldName, type);
    }

    protected String buildColumnName(Field field) {
        return field.getName();
    }

    public Field getField(String name) {
        return this.nameTofield.get(name);
    }

    public Column getColumn(PropertyAccessor field) {
        return this.fieldToColumn.get(field);
    }

    protected FieldFilter getFieldVisitor() {
        return new FieldFilter();
    }

    public static class FieldFilter
    implements Predicate<Field> {
        @Override
        public boolean test(Field field) {
            return !Modifier.isStatic(field.getModifiers());
        }
    }
}

