/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.codefilarete.stalactite.engine.SeparateTransactionExecutor;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.CurrentThreadConnectionProvider;
import org.codefilarete.tool.exception.Exceptions;

public class TransactionalConnectionProvider
implements ConnectionProvider,
SeparateTransactionExecutor {
    private final CurrentThreadConnectionProvider jdbcConnectionProvider;

    public TransactionalConnectionProvider(DataSource dataSource) {
        this.jdbcConnectionProvider = new CurrentThreadConnectionProvider(dataSource);
    }

    @Nonnull
    public Connection giveConnection() {
        return this.jdbcConnectionProvider.giveConnection();
    }

    @Override
    public void executeInNewTransaction(SeparateTransactionExecutor.JdbcOperation jdbcOperation) {
        Connection currentConnection = this.giveConnection();
        Savepoint savepoint = null;
        try {
            savepoint = currentConnection.setSavepoint();
            jdbcOperation.execute();
        }
        catch (Exception e) {
            if (savepoint != null) {
                try {
                    currentConnection.rollback(savepoint);
                    throw Exceptions.asRuntimeException((Throwable)e);
                }
                catch (SQLException e1) {
                    throw Exceptions.asRuntimeException((Throwable)e1);
                }
            }
            throw Exceptions.asRuntimeException((Throwable)e);
        }
        try {
            currentConnection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

