/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.order;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.order.Insert;
import org.codefilarete.stalactite.sql.order.InsertCommandBuilder;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class InsertCommandBuilderTest {
    @Test
    public void testToSQL() {
        Table totoTable = new Table("Toto");
        Column columnA = totoTable.addColumn("a", Long.class);
        Column columnB = totoTable.addColumn("b", String.class);
        Insert insert = new Insert(totoTable).set(columnA).set(columnB, (Object)"tata");
        InsertCommandBuilder testInstance = new InsertCommandBuilder(insert);
        Assertions.assertThat((String)testInstance.toSQL()).isEqualTo("insert into Toto(a, b) values (?, 'tata')");
    }

    @Test
    public void testToStatement() throws SQLException {
        Table totoTable = new Table("Toto");
        Column columnA = totoTable.addColumn("a", Long.class);
        Column columnB = totoTable.addColumn("b", String.class);
        Column columnC = totoTable.addColumn("c", String.class);
        Insert insert = new Insert(totoTable).set(columnA).set(columnB, (Object)"tata").set(columnC);
        InsertCommandBuilder testInstance = new InsertCommandBuilder(insert);
        ColumnBinderRegistry binderRegistry = new ColumnBinderRegistry();
        InsertCommandBuilder.InsertStatement result = testInstance.toStatement(binderRegistry);
        Assertions.assertThat((String)result.getSQL()).isEqualTo("insert into Toto(a, b, c) values (?, ?, ?)");
        Assertions.assertThat((Map)result.getValues()).isEqualTo((Object)Maps.asMap((Object)2, (Object)"tata"));
        Assertions.assertThat((Object)result.getParameterBinder((Object)1)).isEqualTo((Object)DefaultParameterBinders.LONG_BINDER);
        Assertions.assertThat((Object)result.getParameterBinder((Object)2)).isEqualTo((Object)DefaultParameterBinders.STRING_BINDER);
        Assertions.assertThat((Object)result.getParameterBinder((Object)3)).isEqualTo((Object)DefaultParameterBinders.STRING_BINDER);
        result.setValue(columnA, (Object)42L);
        result.setValue(columnC, (Object)"toto");
        PreparedStatement mock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        result.applyValues(mock);
        ((PreparedStatement)Mockito.verify((Object)mock)).setLong(1, 42L);
        ((PreparedStatement)Mockito.verify((Object)mock)).setString(2, "tata");
        ((PreparedStatement)Mockito.verify((Object)mock)).setString(3, "toto");
        binderRegistry.register(columnA, DefaultParameterBinders.LONG_PRIMITIVE_BINDER);
        result = testInstance.toStatement(binderRegistry);
        Assertions.assertThat((Object)result.getParameterBinder((Object)1)).isEqualTo((Object)DefaultParameterBinders.LONG_PRIMITIVE_BINDER);
        result.setValue(columnA, (Object)-42L);
        result.setValue(columnC, (Object)"toto");
        result.applyValues(mock);
        ((PreparedStatement)Mockito.verify((Object)mock)).setLong(1, -42L);
    }
}

