/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.result;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.codefilarete.stalactite.sql.result.ResultSetIterator;
import org.codefilarete.stalactite.sql.result.Row;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinderIndex;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;

public class RowIterator
extends ResultSetIterator<Row> {
    private final Iterable<Decoder> decoders;

    public RowIterator(Map<String, ? extends ResultSetReader> columnNameBinders) {
        this(null, columnNameBinders);
    }

    public RowIterator(@Nullable ResultSet rs, Map<String, ? extends ResultSetReader> columnNameBinders) {
        super(rs);
        this.decoders = Decoder.decoders(columnNameBinders.entrySet());
    }

    public RowIterator(ResultSet rs, ParameterBinderIndex<String, ? extends ResultSetReader> columnNameBinders) {
        super(rs);
        this.decoders = Decoder.decoders(columnNameBinders.all());
    }

    @Override
    public Row convert(ResultSet rs) throws SQLException {
        Row toReturn = new Row();
        for (Decoder columnEntry : this.decoders) {
            String columnName = columnEntry.getColumnName();
            Object columnValue = columnEntry.getReader().get(rs, columnName);
            toReturn.put(columnName, columnValue);
        }
        return toReturn;
    }

    private static class Decoder {
        private final String columnName;
        private final ResultSetReader reader;

        private static Iterable<Decoder> decoders(Iterable<? extends Map.Entry<String, ? extends ResultSetReader>> input) {
            TreeSet<Decoder> result = new TreeSet<Decoder>(Comparator.comparing(Decoder::getColumnName));
            input.forEach(e -> result.add(new Decoder((String)e.getKey(), (ResultSetReader)e.getValue())));
            return result;
        }

        private Decoder(String columnName, ResultSetReader reader) {
            this.columnName = columnName;
            this.reader = reader;
        }

        private String getColumnName() {
            return this.columnName;
        }

        private ResultSetReader getReader() {
            return this.reader;
        }
    }
}

