/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement.binder;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.codefilarete.stalactite.sql.statement.binder.AbstractEnumParameterBinder;

public class OrdinalEnumParameterBinder<E extends Enum<E>>
extends AbstractEnumParameterBinder<E> {
    private final Map<Integer, E> enumPerOrdinal;

    public OrdinalEnumParameterBinder(Class<E> enumType) {
        super(enumType);
        this.enumPerOrdinal = new HashMap<Integer, E>(((Enum[])enumType.getEnumConstants()).length, 1.0f);
        for (Enum enumConstant : (Enum[])enumType.getEnumConstants()) {
            this.enumPerOrdinal.put(enumConstant.ordinal(), enumConstant);
        }
    }

    @Override
    public Class<E> getType() {
        return this.enumType;
    }

    @Override
    public E doGet(ResultSet resultSet, String columnName) throws SQLException {
        return (E)((Enum)this.enumPerOrdinal.get(resultSet.getInt(columnName)));
    }

    @Override
    public void set(PreparedStatement preparedStatement, int valueIndex, E value) throws SQLException {
        preparedStatement.setInt(valueIndex, ((Enum)value).ordinal());
    }
}

