/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import org.codefilarete.reflection.Mutator;
import org.codefilarete.reflection.PropertyAccessor;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.stalactite.engine.VersioningStrategy;
import org.codefilarete.tool.function.Serie;

public abstract class AbstractVersioningStrategy<I, C>
implements VersioningStrategy<I, C>,
Serie<C> {
    private final ReversibleAccessor<I, C> versionAccessor;
    private final Mutator<I, C> versionMutator;

    public AbstractVersioningStrategy(ReversibleAccessor<I, C> versioningAttributeAccessor) {
        this.versionAccessor = versioningAttributeAccessor;
        this.versionMutator = this.versionAccessor.toMutator();
    }

    @Override
    public ReversibleAccessor<I, C> getVersionAccessor() {
        return this.versionAccessor;
    }

    @Override
    public C getVersion(I o) {
        return (C)this.versionAccessor.get(o);
    }

    @Override
    public C upgrade(I o) {
        C currentVersion = this.getVersion(o);
        Object nextVersion = this.next(currentVersion);
        this.versionMutator.set(o, nextVersion);
        return currentVersion;
    }

    @Override
    public C revert(I o, C previousValue) {
        C currentVersion = this.getVersion(o);
        this.versionMutator.set(o, previousValue);
        return currentVersion;
    }

    public static class VersioningStrategySupport<I, C>
    extends AbstractVersioningStrategy<I, C> {
        private final Serie<C> sequence;

        public VersioningStrategySupport(PropertyAccessor<I, C> versioningAttributeAccessor, Serie<C> sequence) {
            super(versioningAttributeAccessor);
            this.sequence = sequence;
        }

        public C next(C previousVersion) {
            return (C)this.sequence.next(previousVersion);
        }
    }
}

