/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.QueryProvider;
import org.codefilarete.stalactite.query.model.QueryStatement;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.SelectablesPod;
import org.codefilarete.stalactite.query.model.UnionAware;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.KeepOrderSet;

public class Union
implements QueryStatement,
UnionAware,
QueryProvider<Union> {
    private final KeepOrderSet<Query> queries;
    private final Map<Selectable<?>, String> aliases = new HashMap();
    private final KeepOrderSet<PseudoColumn<Object>> columns = new KeepOrderSet();

    public Union(Collection<Query> queries) {
        this.queries = new KeepOrderSet(queries);
    }

    public Union(Query ... queries) {
        this.queries = new KeepOrderSet((Object[])queries);
    }

    public KeepOrderSet<Query> getQueries() {
        return this.queries;
    }

    @Override
    public Union getQuery() {
        return this;
    }

    public <O> PseudoColumn<O> addColumn(String expression, Class<O> javaType) {
        return this.addColumn(expression, javaType, null);
    }

    public <O> PseudoColumn<O> addColumn(String expression, Class<O> javaType, @Nullable String alias) {
        return this.addertColumn(new PseudoColumn(this, expression, javaType), alias);
    }

    private <O> PseudoColumn<O> addertColumn(PseudoColumn<O> column, @Nullable String alias) {
        PseudoColumn existingColumn = (PseudoColumn)this.findColumn(column.getExpression(), alias);
        if (existingColumn != null && Objects.equals(alias, this.aliases.get(existingColumn)) && !existingColumn.getJavaType().equals(column.getJavaType())) {
            throw new IllegalArgumentException("Trying to add a column '" + existingColumn.getExpression() + "' that already exists with a different type : " + Reflections.toString(existingColumn.getJavaType()) + " vs " + Reflections.toString(column.getJavaType()));
        }
        if (existingColumn == null) {
            this.columns.add(column);
            return column;
        }
        return existingColumn;
    }

    private <C extends Selectable<?>> C findColumn(String columnName, @Nullable String alias) {
        if (alias != null) {
            for (Map.Entry<Selectable<?>, String> entry : this.getAliases().entrySet()) {
                if (!entry.getValue().equals(alias)) continue;
                return (C)entry.getKey();
            }
        } else {
            for (Selectable selectable : this.getColumns()) {
                if (!(selectable instanceof JoinLink) || !selectable.getExpression().equals(columnName)) continue;
                return (C)selectable;
            }
        }
        return null;
    }

    public <O> PseudoColumn<O> registerColumn(String expression, Class<O> javaType) {
        return this.addColumn(expression, javaType);
    }

    public <O> PseudoColumn<O> registerColumn(String expression, Class<O> javaType, String alias) {
        return this.addColumn(expression, javaType, alias);
    }

    public Set<PseudoColumn<?>> getColumns() {
        return this.columns;
    }

    public Map<Selectable<?>, String> getAliases() {
        return this.aliases;
    }

    @Override
    public Union unionAll(QueryProvider<Query> query) {
        this.queries.add((Object)query.getQuery());
        return this;
    }

    public UnionInFrom asPseudoTable(String name) {
        return new UnionInFrom(name, this);
    }

    @Override
    public Map<String, ? extends Selectable<?>> mapColumnsOnName() {
        HashMap<String, PseudoColumn<Object>> result = new HashMap<String, PseudoColumn<Object>>();
        for (PseudoColumn<?> pseudoColumn : this.getColumns()) {
            result.put(pseudoColumn.getExpression(), pseudoColumn);
        }
        for (Map.Entry entry : this.getAliases().entrySet()) {
            result.put((String)entry.getValue(), (PseudoColumn<Object>)entry.getKey());
        }
        return result;
    }

    public static class PseudoColumn<O>
    implements Selectable<O>,
    JoinLink<Fromable, O> {
        private final SelectablesPod union;
        private final String name;
        private final Class<O> javaType;

        private PseudoColumn(SelectablesPod union, String name, Class<O> javaType) {
            this.union = union;
            this.name = name;
            this.javaType = javaType;
        }

        @Override
        public Fromable getOwner() {
            return (Fromable)this.union;
        }

        @Override
        public String getExpression() {
            return this.name;
        }

        @Override
        public Class<O> getJavaType() {
            return this.javaType;
        }
    }

    public static class UnionInFrom
    implements Fromable {
        private final String name;
        private final Union union;
        private final KeepOrderSet<PseudoColumn<Object>> columns = new KeepOrderSet();
        private final Map<Selectable<?>, String> aliases = new HashMap();

        public UnionInFrom(String name, Union union) {
            this.name = name;
            this.union = union;
            Map<Selectable<?>, String> unionAliases = union.getAliases();
            for (PseudoColumn<?> column : union.getColumns()) {
                PseudoColumn newPseudoColumn = new PseudoColumn(this, column.getExpression(), column.getJavaType());
                this.columns.add(newPseudoColumn);
                String alias = unionAliases.get(column);
                if (alias == null) continue;
                this.aliases.put(newPseudoColumn, alias);
            }
        }

        public Union getUnion() {
            return this.union;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getAbsoluteName() {
            return this.getName();
        }

        public Set<PseudoColumn<?>> getColumns() {
            return this.columns;
        }

        public Map<Selectable<?>, String> getAliases() {
            return this.aliases;
        }

        @Override
        public Map<String, ? extends Selectable<?>> mapColumnsOnName() {
            return this.union.mapColumnsOnName();
        }
    }
}

