/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement.binder;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.PreparedStatementWriter;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;
import org.codefilarete.tool.function.SerializableThrowingFunction;

public class LambdaParameterBinder<T>
implements ParameterBinder<T> {
    private final ResultSetReader<T> resultSetReader;
    private final PreparedStatementWriter<T> preparedStatementWriter;
    private final ParameterBinder<?> delegate;

    public LambdaParameterBinder(ResultSetReader<T> resultSetReader, PreparedStatementWriter<T> preparedStatementWriter) {
        this.resultSetReader = resultSetReader;
        this.preparedStatementWriter = preparedStatementWriter;
        this.delegate = null;
    }

    public <I> LambdaParameterBinder(ParameterBinder<I> delegate, SerializableThrowingFunction<I, T, ? extends Throwable> resultSetConverter, SerializableThrowingFunction<T, I, ? extends Throwable> statementInputConverter) {
        this.resultSetReader = delegate.thenApply(resultSetConverter);
        this.preparedStatementWriter = delegate.preApply(statementInputConverter);
        this.delegate = delegate;
    }

    @Override
    public Class<T> getType() {
        return this.resultSetReader.getType();
    }

    @Override
    public <O> Class<O> getColumnType() {
        return this.delegate == null ? this.getType() : this.delegate.getColumnType();
    }

    @Override
    public T doGet(ResultSet resultSet, String columnName) {
        return this.resultSetReader.get(resultSet, columnName);
    }

    @Override
    public void set(PreparedStatement statement, int valueIndex, T value) throws SQLException {
        this.preparedStatementWriter.set(statement, valueIndex, value);
    }
}

