/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.cascade;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.listener.InsertListener;
import org.codefilarete.tool.collection.Collections;
import org.codefilarete.tool.collection.Iterables;

public abstract class AfterInsertCollectionCascader<TRIGGER, TARGET>
implements InsertListener<TRIGGER> {
    private final EntityPersister<TARGET, ?> persister;

    public AfterInsertCollectionCascader(EntityPersister<TARGET, ?> persister) {
        this.persister = persister;
        this.persister.addInsertListener(new InsertListener<TARGET>(){

            public void afterInsert(Iterable<? extends TARGET> entities) {
                AfterInsertCollectionCascader.this.postTargetInsert(entities);
            }
        });
    }

    public EntityPersister<TARGET, ?> getPersister() {
        return this.persister;
    }

    public void afterInsert(Iterable<? extends TRIGGER> entities) {
        Stream stream = Iterables.stream(entities);
        Stream<Set> targetStream = stream.flatMap(c -> this.getTargets(c).stream());
        Set collect = targetStream.collect(Collectors.toCollection(Collections::newIdentitySet));
        this.persister.persist((Iterable)collect);
    }

    protected abstract void postTargetInsert(Iterable<? extends TARGET> var1);

    protected abstract Collection<TARGET> getTargets(TRIGGER var1);
}

